<?php
namespace server\idcsmart_jykj\validate;

use app\common\model\ProductModel;
use server\idcsmart_jykj\logic\IdcsmartJykjLogic;
use server\idcsmart_jykj\model\IdcsmartJykjCustomCycleModel;
use server\idcsmart_jykj\model\IdcsmartJykjProductConfigoptionModel;
use server\idcsmart_jykj\model\IdcsmartJykjProductModel;
use server\idcsmart_jykj\model\IdcsmartJykjServerModel;
use think\Validate;

/**
 * 商品验证
 */
class IdcsmartJykjProductValidate extends Validate
{
	protected $rule = [
		'allow_qty' => 'require|in:0,1',
		'auto_support' => 'require|in:0,1',
        'pricing' => 'require|checkPricing:thinkphp',
        'configoption' => 'array|checkConfigoption:thinkphp',
        'cycle' => 'require|checkCycle:thinkphp',
        'product_id' => 'integer',
        'server_id' => 'integer|checkServer:thinkphp',
        'qty' => 'integer|checkQty:thinkphp',
    ];

    protected $message  =   [
    ];

    protected $scene = [
        'create' => ['allow_qty','auto_support','pricing','server_id'],
        'cart_calculate' => ['configoption','cycle','product_id','qty'],
    ];

    protected function checkServer($value,$rule,$data){
        $IdcsmartJykjServerModel = new IdcsmartJykjServerModel();
        $exist = $IdcsmartJykjServerModel->find($value);
        if (empty($exist)){
            return "子接口不存在";
        }

        return true;
    }

    protected function checkPricing($value,$rule,$data)
    {
        $productId = $data['product_id'];
        $ProductModel = new ProductModel();
        $product = $ProductModel->find($productId);
        if ($product['pay_type']=='free'){
            return true;
        }

        $IdcsmartJykjPricingValidate = new IdcsmartJykjPricingValidate();

        if (!$IdcsmartJykjPricingValidate->check($value)){
            return $IdcsmartJykjPricingValidate->getError();
        }

        return true;
    }

    # 检查周期
    protected function checkCycle($value,$rule,$data)
    {
        $productId = $data['product_id'];
        if ($value == 'free'){
            $ProductModel = new ProductModel();
            $product = $ProductModel->find($productId);
            if ($product['pay_type']!='free'){
                return lang_plugins('cycle_error');
            }
            return true;
        }

        $IdcsmartJykjCustomCycleModel = new IdcsmartJykjCustomCycleModel();
        $customCycle = $IdcsmartJykjCustomCycleModel->alias('cc')
            ->leftJoin('module_idcsmart_jykj_custom_cycle_pricing ccp','ccp.custom_cycle_id=cc.id AND ccp.type=\'product\'')
            ->where('cc.product_id',$productId)
            ->where('ccp.rel_id',$productId)
            ->where('ccp.amount','>=',0)
            ->where('cc.id',intval($value))
            ->find();

        $IdcsmartJykjLogic = new IdcsmartJykjLogic();
        if (!in_array($value,array_keys($IdcsmartJykjLogic->systemCycles)) && empty($customCycle)){

            return lang_plugins('cycle_error');
        }

        return true;
    }

    # 检查配置项
    protected function checkConfigoption($value)
    {
        $IdcsmartJykjLogic = new IdcsmartJykjLogic();

        $IdcsmartJykjProductConfigoptionModel = new IdcsmartJykjProductConfigoptionModel();
        foreach ($value as $key=>$item){
            $configoption = $IdcsmartJykjProductConfigoptionModel->where('id',$key)->find();
            if (empty($configoption)){
                return lang_plugins('idcsmart_jykj_configoption_not_exist');
            }

            $optionType = $configoption['option_type'];
            if ($IdcsmartJykjLogic->checkQuantity($optionType)){
                if (!is_array($item)){
                    return lang_plugins('param_error');
                }

                if (!$configoption['allow_repeat'] && count($item)>1){
                    return lang_plugins('param_error');
                }
                if ($configoption['allow_repeat'] && count($item)>$configoption['max_repeat']){
                    return lang_plugins('idcsmart_jykj_configoption_option_type_quantity_max_repeat_error');
                }

                foreach ($item as $v){
                    if ($v>$configoption['qty_max'] || $v<$configoption['qty_min']){
                        return lang_plugins('qty_error');
                    }
                }

            }elseif ($IdcsmartJykjLogic->checkMultiSelect($optionType)){
                foreach ($item as $v){
                    $tmp = $IdcsmartJykjProductConfigoptionModel->alias('pc')
                        ->leftJoin('module_idcsmart_jykj_product_configoption_sub pcs','pcs.product_configoption_id=pc.id')
                        ->where('pc.hidden',0)
                        ->where('pcs.hidden',0)
                        ->where('pc.id',$key)
                        ->where('pcs.id',$v)
                        ->find();
                    if (empty($tmp)){
                        return lang_plugins('param_error');
                    }
                }
            }else{
                $tmp = $IdcsmartJykjProductConfigoptionModel->alias('pc')
                    ->leftJoin('module_idcsmart_jykj_product_configoption_sub pcs','pcs.product_configoption_id=pc.id')
                    ->where('pc.hidden',0)
                    ->where('pcs.hidden',0)
                    ->where('pc.id',$key)
                    ->where('pcs.id',$item)
                    ->find();
                if (empty($tmp)){
                    return lang_plugins('param_error');
                }
            }
        }

        return true;
    }

    protected function checkQty($value,$rule,$data)
    {

        $productId = $data['product_id'];

        $IdcsmartJykjProductModel = new IdcsmartJykjProductModel();

        $allowQty = $IdcsmartJykjProductModel->where('product_id',$productId)->value('allow_qty');

        if (!$allowQty && $value>1){
            return lang_plugins('cannot_qty');
        }

        return true;
    }
}