const template = document.getElementsByClassName("common-config")[0];
Vue.prototype.lang = Object.assign(window.lang, window.module_lang);
new Vue({
  components: {
    asideMenu,
    topMenu,
    payDialog,
    discountCode,
    eventCode,
    customGoods,
  },
  created() {
    if (window.performance.navigation.type === 2) {
      sessionStorage.removeItem("product_information");
    }
    const params = getUrlParams();
    this.id = params.id;
    let temp = {};
    if (params.config || sessionStorage.getItem("product_information")) {
      try {
        temp = JSON.parse(params.config);
      } catch (e) {
        temp = JSON.parse(sessionStorage.getItem("product_information")) || {};
      }
    }

    // 回显配置
    if (temp && temp.config_options) {
      this.backfill = temp.config_options;
      this.configForm.config_options = temp.config_options;
      this.customfield = temp.customfield;
      this.self_defined_field = temp.self_defined_field || {};
      this.cycle = temp.config_options.cycle;
      this.orderData.qty = temp.qty;
      this.position = temp.position;
    }
    this.getCommonData();
    this.getGoodsName();
    this.getCountryList();
  },
  mounted() {
    this.addons_js_arr = JSON.parse(
      document.querySelector("#addons_js").getAttribute("addons_js")
    ); // 插件列表
    const arr = this.addons_js_arr.map((item) => {
      return item.name;
    });
    if (arr.includes("PromoCode")) {
      // 开启了优惠码插件
      this.isShowPromo = true;
    }
    if (arr.includes("IdcsmartClientLevel")) {
      // 开启了等级优惠
      this.isShowLevel = true;
    }
    if (arr.includes("EventPromotion")) {
      // 开启活动满减
      this.isShowFull = true;
    }
    if (arr.includes("EventPromotion")) {
      // 开启活动满减
      this.isShowFull = true;
    }
    this.getConfig();
    window.addEventListener("message", (event) => this.buyNow(event));
  },
  updated() {
    // 关闭loading
    document.getElementById("mainLoading").style.display = "none";
    document.getElementsByClassName("template")[0].style.display = "block";
    this.isShowBtn = true;
  },
  destroyed() {},
  computed: {
    calStr() {
      const temp = this.basicInfo.order_page_description
        ?.replace(/&lt;/g, "<")
        .replace(/&gt;/g, ">")
        .replace(/&quot;/g, '"')
        .replace(/&/g, "&")
        .replace(/"/g, '"')
        .replace(/'/g, "'");
      return temp;
    },
    calcDes() {
      return (val) => {
        const temp = val
          .replace(/&lt;/g, "<")
          .replace(/&gt;/g, ">")
          .replace(/&quot;/g, '"')
          .replace(/&/g, "&")
          .replace(/"/g, '"')
          .replace(/'/g, "'");
        return temp;
      };
    },
    calcSwitch() {
      return (item, type) => {
        if (type) {
          const arr = item.subs.filter((item) => item.option_name === lang.yes);
          return arr[0]?.id;
        } else {
          const arr = item.subs.filter((item) => item.option_name === lang.no);
          return arr[0]?.id;
        }
      };
    },
    calcCountry() {
      return (val) => {
        return this.countryList.filter((item) => val === item.iso)[0]?.name_zh;
      };
    },
    calcCity() {
      return (id) => {
        return this.filterCountry[id].filter(
          (item) => item[0]?.country === this.curCountry[id]
        )[0];
      };
    },
  },

  filters: {
    formateTime(time) {
      if (time && time !== 0) {
        return formateDate(time * 1000);
      } else {
        return "--";
      }
    },
    filterMoney(money) {
      if (isNaN(money) || money * 1 < 0) {
        return "0.00";
      } else {
        return formatNuberFiexd(money);
      }
    },
  },
  data() {
    return {
      id: "",
      goodsInfo: {},
      position: "",
      addons_js_arr: [], // 插件数组
      isShowPromo: false, // 是否开启优惠码
      isShowLevel: false, // 是否开启等级优惠
      isShowFull: false,
      is_show_custom: false,
      isUseDiscountCode: false, // 是否使用优惠码
      backfill: {}, // 回填参数
      customfield: {}, // 自定义字段
      self_defined_field: {}, // 自定义字段
      submitLoading: false,
      totalPrice: 0,
      commonData: {},
      eventData: {
        id: "",
        discount: 0,
      },
      // 订单数据
      orderData: {
        qty: 1,
        // 是否勾选阅读
        isRead: false,
        // 付款周期
        duration: "",
      },
      // 右侧展示区域
      showInfo: [],
      base_price: "",
      // 商品原单价
      onePrice: 0,
      // 商品原总价
      original_price: 0,

      timerId: null, // 订单id
      basicInfo: {}, // 基础信息
      configoptions: [], // 配置项
      custom_cycles: [], // 自定义周期
      curCycle: 0,
      cycle: "",
      onetime: "",
      pay_type: "",
      // 提交数据
      configForm: {
        // 自定义配置项
      },
      isShowBtn: false,
      // 国家列表
      countryList: [],
      // 处理过后的国家列表
      filterCountry: {},
      curCountry: {}, // 当前国家，根据配置id存入对应的初始索引
      cartDialog: false,
      dataLoading: false,
      selectOsObj: {},
      // 客户等级折扣金额
      clDiscount: 0,
      // 优惠码折扣金额
      code_discount: 0,
      osSelectData: [],
      osGroupId: "",
      osIcon: "",
      // 验证方式控制
      verificationMethod: '', // 当前选择的验证方式
      // 省份筛选相关
      selectedProvinces: [], // 选中的省份
      provinceList: [], // 省份列表
      filteredCityOptions: [], // 筛选后的城市选项（用于显示）
    };
  },
  methods: {
    getGoodsName() {
      productInfo(this.id).then((res) => {
        this.goodsInfo = res.data.data.product;
        document.title =
          this.commonData.website_name + "-" + res.data.data.product.name;
      });
    },
    // 解析url
    getQuery(url) {
      const str = url.substr(url.indexOf("?") + 1);
      const arr = str.split("&");
      const res = {};
      for (let i = 0; i < arr.length; i++) {
        const item = arr[i].split("=");
        res[item[0]] = item[1];
      }
      return res;
    },
    async getCountryList() {
      try {
        const res = await getCountry();
        this.countryList = res.data.data.list;
      } catch (error) {}
    },
    // 镜像分组改变时
    osSelectGroupChange(e, item) {
      const obj = item.subs.filter((sub) => sub.os === this.osGroupId)[0];
      this.osSelectData = obj.version;
      this.osIcon =
        "/plugins/server/idcsmart_jykj/template/clientarea/pc/default/img/idcsmart_jykj/" +
        obj.os +
        ".svg";
      this.configForm[item.id] = obj.version[0].id;
      this.changeConfig();
    },
    eventChange(evetObj) {
      if (this.eventData.id !== evetObj.id) {
        this.eventData.id = evetObj.id || "";
        this.customfield.event_promotion = this.eventData.id;
        this.changeConfig();
      }
    },
    // 镜像版本改变时
    osSelectChange() {
      this.changeConfig();
    },
    async getConfig() {
      try {
        const res = await getCommonDetail(this.id);
        const temp = res.data.data;
        this.basicInfo = temp.common_product;
        this.configoptions = temp.configoptions.filter(
          (item) => item.subs.length
        );
        this.custom_cycles = temp.custom_cycles;
        this.pay_type = temp.common_product.pay_type;
        this.onetime =
          temp.cycles.onetime === "-1.00" ? "0.00" : temp.cycles.onetime;
        // 初始化自定义配置参数
        const obj = this.configoptions.reduce((all, cur) => {
          // 城市配置项不默认选中任何值
          if (cur.option_type === "multi_select" && cur.option_name === "城市") {
            all[cur.id] = [];
          } else if (cur.option_type === "multi_select" ||
            cur.option_type === "quantity" ||
            cur.option_type === "quantity_range") {
            all[cur.id] = [
              cur.option_type === "multi_select"
                ? cur.subs[0].id
                : cur.subs[0].qty_min,
            ];
          } else {
            all[cur.id] = cur.subs[0].id;
          }
          // 区域的时候保存国家
          if (cur.option_type === "area") {
            this.filterCountry[cur.id] = this.toTree(cur.subs);
            this.$set(this.curCountry, cur.id, 0);
          }
          
          // 提取省份列表 - 从城市配置项中提取（类型为multi_select）
          if (cur.option_type === "multi_select" && cur.option_name === "城市") {
            if (cur.subs && cur.subs.length > 0) {
              const provinces = this.extractProvinces(cur.subs);
              if (provinces.length > 0) {
                this.provinceList = provinces;
              }
            }
          }

          if (cur.option_type === "os") {
            this.osGroupId = cur.subs[0].os;
            this.osSelectData = cur.subs[0].version;
            all[cur.id] = cur.subs[0].version[0].id;
            this.osIcon =
              "/plugins/server/idcsmart_jykj/template/clientarea/pc/default/img/idcsmart_jykj/" +
              cur.subs[0].os +
              ".svg";
          }
          return all;
        }, {});
        this.configForm = obj;
        if (this.pay_type === "onetime") {
          this.cycle = "onetime";
        } else if (this.pay_type === "free") {
          this.cycle = "free";
        } else {
          this.cycle = temp.custom_cycles[0].id;
        }

        // this.changeConfig()
        this.changeConfig(this.backfill.cycle ? true : false);
      } catch (error) {}
    },
    // 数组转树
    toTree(data) {
      var temp = Object.values(
        data.reduce((res, item) => {
          res[item.country]
            ? res[item.country].push(item)
            : (res[item.country] = [item]);
          return res;
        }, {})
      );
      return temp;
    },
    // 切换配置选项
    changeItem() {
      // if (item.option_type === 'multi_select') {
      //   // 获取选中的 id 列表
      //   const selectedIds = this.configForm[item.id];

      //   // 获取选中的文本值
      //   const selectedLabels = item.subs.filter(sub => selectedIds.includes(sub.id))
      //                                   .map(sub => sub.option_name);

      //   console.log('选中的文本值（label）:', selectedLabels);
      // }
      
      this.changeConfig();
    },
    // 使用优惠码
    getDiscount(data) {
      this.customfield.promo_code = data[1];
      this.isUseDiscountCode = true;
      this.changeConfig();
    },
    // 更改配置计算价格
    async changeConfig(bol = false) {
      let multiSelectValue = ''; // 用于存储选中的多选值
      let quantityValue = 0; // 用于存储数量框的值
      let totalAvailableQuantity=0;

      this.configoptions.forEach(item => {
        // 获取多选框的具体值
        if (item.option_type === 'multi_select') {
          const selectedIds = this.configForm[item.id] || [];
          multiSelectValue = item.subs.filter(sub => selectedIds.includes(sub.id))
                                      .map(sub => sub.option_name).join(','); // 将选中的文本拼接为字符串
        }

        // 获取数据输入框的具体值
        if (item.option_type === 'quantity') {
          
          quantityValue = this.configForm[item.id]; // 获取数量框的值
        }
      });
      // if (multiSelectValue==''){
      //   this.$message.warning("请选择城市");
      //   return;
      // }
     
   // 正则表达式提取多选框中每个选项的数量并相加
    if (multiSelectValue) {
      const quantityFromMultiSelect = multiSelectValue.split(',').map(item => {
        const match = item.match(/\(可用(\d+)个\)/); // 提取括号中的数字
        return match ? parseInt(match[1]) : 0; // 返回数字，默认返回0如果没有匹配到
      });

      // 计算所有选项的数量总和
      totalAvailableQuantity = quantityFromMultiSelect.reduce((acc, val) => acc + val, 0);
      console.log('totalAvailableQuantity', totalAvailableQuantity);
      if (quantityValue>totalAvailableQuantity){
        this.$message.warning("抱歉当前地区数量不能满足你")
        setTimeout(() => {
          location.reload();
        }, 1000); // 1000 毫秒即 1 秒
        return;
      }
   }
    

      console.log('多选框选中的值:', multiSelectValue); // 返回多选框的具体值
      console.log('数据输入框的值:', quantityValue); // 返回数据输入框的具体值
      try {
        if (bol) {
          /* 处理 quantity quantity_range  */
          const _temp = this.backfill.configoption;
          Object.keys(_temp).forEach((item) => {
            const type = this.configoptions.filter((el) => el.id === item)[0]
              ?.option_type;
            if (type === "quantity" || type === "quantity_range") {
              _temp[item] = _temp[item][0];
            }
          });
          this.configForm = _temp;
          this.cycle = this.backfill.cycle;
          this.curCycle = this.custom_cycles.findIndex(
            (item) => item.id * 1 === this.cycle * 1
          );
        }
        const temp = this.formatData();

        const params = {
          id: this.id,
          config_options: {
            configoption: temp,
            cycle: this.cycle,
            promo_code: this.customfield.promo_code,
            event_promotion: this.customfield.event_promotion,
          },
          qty: this.orderData.qty,
        };
        this.dataLoading = true;
        const res = await calcPrice(params);

        this.original_price = res.data.data.price * 1;
        this.totalPrice = res.data.data.price_total * 1;
        this.clDiscount = res.data.data.price_client_level_discount * 1 || 0;
        this.code_discount = res.data.data.price_promo_code_discount * 1 || 0;
        this.eventData.discount =
          res.data.data.price_event_promotion_discount * 1 || 0;

        this.base_price = res.data.data.base_price;
        this.showInfo = res.data.data.preview;
        this.onePrice = res.data.data.price; // 原单价
        this.orderData.duration = res.data.data.duration;

        // 重新计算周期显示
        const result = await calculate(params);
        this.custom_cycles = result.data.data.custom_cycles;
        this.onetime = result.data.data.cycles.onetime;
        this.dataLoading = false;
      } catch (error) {
        this.dataLoading = false;
      }
    },
    removeDiscountCode() {
      this.isUseDiscountCode = false;
      this.customfield.promo_code = "";
      this.code_discount = 0;
      this.changeConfig();
    },
    // 切换国家
    changeCountry(id, index) {
      this.$set(this.curCountry, id, index);
      this.configForm[id] = this.filterCountry[id][index][0]?.id;
      this.changeConfig();
    },
    // 切换城市
    changeCity(el, id) {
      this.configForm[id] = el.id;
      this.changeConfig();
    },
    // 切换单击选择
    changeClick(id, el) {
      this.configForm[id] = el.id;
      this.changeConfig();
    },
    // 切换数量
    changeNum(val, id) {
      this.configForm[id] = [val * 1];
      this.changeConfig();
    },
    // 切换周期
    changeCycle(item, index) {
      this.cycle = item.id;
      this.curCycle = index;
      this.changeConfig();
    },
    // 商品购买数量减少
    delQty() {
      if (this.basicInfo.allow_qty === 0) {
        return false;
      }
      if (this.orderData.qty > 1) {
        this.orderData.qty--;
        this.changeConfig();
      }
    },
    // 商品购买数量增加
    addQty() {
      if (this.basicInfo.allow_qty === 0) {
        return false;
      }
      this.orderData.qty++;
      this.changeConfig();
    },

    formatData() {
      // 处理数量类型的转为数组
      const temp = JSON.parse(JSON.stringify(this.configForm));
      //console.log(temp)
      Object.keys(temp).forEach((el) => {
        const arr = this.configoptions.filter((item) => item.id * 1 === el * 1);
        if (
          arr[0].option_type === "quantity" ||
          arr[0].option_type === "quantity_range" ||
          arr[0].option_type === "multi_select"
        ) {
          if (typeof temp[el] !== "object") {
            temp[el] = [temp[el]];
          }
        }
      });
      return temp;
    },
    // 立即购买
    async buyNow(e) {
      //console.log(this.formatData())
      
       
      if (e.data && e.data.type !== "iframeBuy") {
        return;
      }
      if (
        Boolean(
          (JSON.parse(localStorage.getItem("common_set_before")) || {})
            .custom_fields?.before_settle === 1
        )
      ) {
        window.open("/account.htm");
        return;
      }
      // 验证城市是否必选
      if (!this.validateCityRequired()) {
        return;
      }
      
      const flag = this.$refs.customGoodRef.getSelfDefinedField();
      if (!flag) return;
      const temp = this.formatData();
      //这里做数量的处理
      console.log(temp)
      const params = {
        product_id: this.id,
        config_options: {
          configoption: temp,
          cycle: this.cycle,
        },
        qty: this.orderData.qty,
        customfield: this.customfield,
        self_defined_field: this.self_defined_field,
      };
      
      // 直接传配置到结算页面
      if (e.data && e.data.type === "iframeBuy") {
        const postObj = { type: "iframeBuy", params, price: this.totalPrice };
        window.parent.postMessage(postObj, "*");
        return;
      }
      location.href = `/cart/settlement.htm?id=${params.product_id}`;
      sessionStorage.setItem("product_information", JSON.stringify(params));
    },
    // 加入购物车
    async addCart() {
      // if (!this.orderData.isRead) {
      //   this.$message.warning("请先阅读并勾选协议")
      //   return false
      // }
      try {
        // 验证城市是否必选
        if (!this.validateCityRequired()) {
          return;
        }
        
        const flag = this.$refs.customGoodRef.getSelfDefinedField();
        if (!flag) return;
        const temp = this.formatData();
        const params = {
          product_id: this.id,
          config_options: {
            configoption: temp,
            cycle: this.cycle,
          },
          qty: this.orderData.qty,
          customfield: this.customfield,
          self_defined_field: this.self_defined_field,
        };
        const res = await addToCart(params);
        if (res.data.status === 200) {
          this.cartDialog = true;
          const result = await getCart();
          localStorage.setItem(
            "cartNum",
            "cartNum-" + result.data.data.list.length
          );
        }
      } catch (error) {
        this.$message.error(error.data.msg);
      }
    },
    // 修改购物车
    async changeCart() {
      try {
        const flag = this.$refs.customGoodRef.getSelfDefinedField();
        if (!flag) return;
        const temp = this.formatData();
        const params = {
          position: this.position,
          product_id: this.id,
          config_options: {
            configoption: temp,
            cycle: this.cycle,
          },
          qty: this.orderData.qty,
          customfield: this.customfield,
          self_defined_field: this.self_defined_field,
        };
        this.dataLoading = true;
        const res = await updateCart(params);
        this.$message.success(res.data.msg);
        setTimeout(() => {
          location.href = "/cart/shoppingCar.htm";
        }, 300);
        this.dataLoading = false;
      } catch (error) {
        console.log("errore", error);
        this.$message.error(error.data.msg);
      }
    },
    goToCart() {
      location.href = "/cart/shoppingCar.htm";
      this.cartDialog = false;
    },
    // 支付成功回调
    paySuccess(e) {
      this.submitLoading = false;
      location.href = "common_product_list.htm";
    },
    // 取消支付回调
    payCancel(e) {
      this.submitLoading = false;
      location.href = "finance.htm";
    },
    // 获取通用配置
    getCommonData() {
      this.commonData = JSON.parse(localStorage.getItem("common_set_before"));

      document.title =
        this.commonData.website_name + "-" + lang.common_cloud_text109;
    },
     // 比较提取的数量和输入的值
  compareAvailableWithInput(item) {
    // 获取可用数量文本，假设 item.option_name 是 "荆门s502(可用106个)"
    const availableText = item.option_name;
    const availableNumber = this.extractAvailableNumber(availableText);

    // 获取 `<el-input-number>` 输入的值
    const inputValue = this.configForm[item.id];

    // 进行比较
    if (inputValue > availableNumber) {
      this.$message.error('输入的数量不能超过可用数量');
      // 如果需要，可以设置为最大可用数量
      this.configForm[item.id] = availableNumber;
    }
  },

  // 从文本中提取 "可用" 后的数字
  extractAvailableNumber(text) {
    const match = text.match(/可用(\d+)个/);
    return match ? parseInt(match[1], 10) : 0;
  },
  getSelectedLabels(item) {
    // 获取选中的值 (id 数组)
    const selectedIds = this.configForm[item.id];

    // 在 item.subs 中查找匹配的文本值
    const selectedLabels = item.subs
      .filter(subItem => selectedIds.includes(subItem.id))
      .map(subItem => subItem.option_name);

    return selectedLabels;
  },
  
  // 处理验证方式变化
  onVerificationMethodChange(value) {
    this.verificationMethod = value;
    
    // 如果切换到白名单验证，清空账号密码字段
    if (value === '白名单验证') {
      // 清空账号密码字段
      Object.keys(this.self_defined_field).forEach(key => {
        // 这里需要根据实际的字段ID来清空，暂时用字段名匹配
        // 实际使用时可能需要调整
        if (this.self_defined_field[key] && 
            (this.self_defined_field[key].includes('账号') || 
             this.self_defined_field[key].includes('密码'))) {
          this.self_defined_field[key] = '';
        }
      });
    }
    
    // 如果切换到账号密码验证，清空白名单字段
    if (value === '账号密码验证') {
      // 清空白名单字段
      Object.keys(this.self_defined_field).forEach(key => {
        if (this.self_defined_field[key] && 
            this.self_defined_field[key].includes('白名单')) {
          this.self_defined_field[key] = '';
        }
      });
    }
  },
  
  // 判断字段是否应该显示
  shouldShowCustomField(fieldName) {
    // 如果没有选择验证方式，显示所有字段
    if (!this.verificationMethod) {
      return true;
    }
    
    // 根据验证方式决定字段显示
    if (this.verificationMethod === '账号密码验证') {
      // 账号密码验证时，隐藏白名单字段
      if (fieldName === '代理IP_白名单') {
        return false;
      }
    } else if (this.verificationMethod === '白名单验证') {
      // 白名单验证时，隐藏账号密码字段
      if (fieldName === '代理IP_账号' || fieldName === '代理IP_密码') {
        return false;
      }
    }
    
    return true;
  },
  
  // 提取省份列表
  extractProvinces(cityData) {
    const provinces = new Set();
    cityData.forEach(city => {
      // 使用正则表达式提取省份名称，格式如 "安徽-苏州s503(可用27个)"
      const match = city.option_name.match(/^([^-]+)-/);
      if (match) {
        provinces.add(match[1]);
      }
    });
    return Array.from(provinces).sort();
  },
  
  // 根据选中的省份筛选城市
  filterCitiesByProvinces(cityData, selectedProvinces) {
    if (!selectedProvinces || selectedProvinces.length === 0) {
      return cityData;
    }
    
    return cityData.filter(city => {
      const match = city.option_name.match(/^([^-]+)-/);
      if (match) {
        return selectedProvinces.includes(match[1]);
      }
      return false;
    });
  },
  
  // 省份选择变化处理
  onProvinceChange(selectedProvinces) {
    this.selectedProvinces = selectedProvinces;
    
    // 筛选所有城市数据
    this.configoptions.forEach(item => {
      if ((item.option_type === 'area' || (item.option_type === 'multi_select' && item.option_name === '城市')) && item.subs) {
        const filteredCities = this.filterCitiesByProvinces(item.subs, selectedProvinces);
        
        // 更新筛选后的城市选项（用于显示）
        if (item.id) {
          this.filteredCityOptions = filteredCities;
          
          // 清除不在筛选范围内的城市选择
          if (this.configForm[item.id]) {
            // 如果是多选，需要检查每个选中的城市
            if (Array.isArray(this.configForm[item.id])) {
              const validCityIds = filteredCities.map(city => city.id);
              const filteredSelectedCities = this.configForm[item.id].filter(cityId => {
                return validCityIds.includes(cityId);
              });
              this.configForm[item.id] = filteredSelectedCities;
            } else {
              // 如果是单选，检查选中的城市是否在筛选范围内
              const validCityIds = filteredCities.map(city => city.id);
              if (!validCityIds.includes(this.configForm[item.id])) {
                this.configForm[item.id] = null;
              }
            }
          }
        }
      }
    });
  },
  
  // 获取城市选项（根据省份筛选）
  getCityOptions(item) {
    // 如果是城市配置项且已选择省份，返回筛选后的城市
    if (item.option_type === 'multi_select' && item.option_name === '城市' && this.selectedProvinces.length > 0) {
      return this.filteredCityOptions;
    }
    // 否则返回原始城市选项
    return item.subs;
  },
  
  // 验证城市是否必选
  validateCityRequired() {
    // 查找城市配置项
    const cityConfig = this.configoptions.find(item => 
      item.option_type === 'multi_select' && item.option_name === '城市'
    );
    
    if (!cityConfig) {
      return true; // 如果没有城市配置项，则不需要验证
    }
    
    const cityValue = this.configForm[cityConfig.id];
    
    // 检查城市是否已选择
    if (!cityValue || (Array.isArray(cityValue) && cityValue.length === 0)) {
      this.$message.warning('请选择城市');
      return false;
    }
    
    return true;
  },
  
  },
}).$mount(template);
