<?php 

use think\facade\Route;

$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';

// 不需要登录
Route::group('console/v1',function (){
    Route::get('idcsmart_jykj/product/:product_id/configoption', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@cartConfigoption");
    Route::post('idcsmart_jykj/product/:product_id/configoption/calculate', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@cartConfigoptionCalculate");
})->allowCrossDomain([
    'Access-Control-Allow-Origin'        => $origin,
    'Access-Control-Allow-Credentials'   => 'true',
    'Access-Control-Max-Age'             => 600,
])->middleware(\app\http\middleware\Check::class);

// 前台需要登录的接口
Route::group('console/v1',function (){
    
	Route::get('idcsmart_jykj/host', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@hostList");

    Route::get('idcsmart_jykj/host/:host_id/configoption', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@hostConfigotpion");

    Route::get('idcsmart_jykj/host/:host_id/configoption/area', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@clientAreaOutput");
    Route::post('idcsmart_jykj/host/:host_id/configoption/chart', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@chartData");
    Route::post('idcsmart_jykj/host/:host_id/provision/status', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@provisionFuncStatus");
    Route::post('idcsmart_jykj/host/:host_id/provision/:func', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@provisionFunc")->middleware(\app\http\middleware\CheckClientOperatePassword::class);
    Route::post('idcsmart_jykj/host/:host_id/custom/provision', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@provisionFuncCustom");

    Route::get('idcsmart_jykj/host/:host_id/upgrade', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@upgradePage");

    Route::post('idcsmart_jykj/host/:host_id/sync_upgrade_price', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@syncUpgradePrice");

    Route::post('idcsmart_jykj/host/:host_id/upgrade', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@upgrade");

    Route::get('idcsmart_jykj/host/:host_id/upgrade_config', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@upgradeConfigPage");

    Route::post('idcsmart_jykj/host/:host_id/sync_upgrade_config_price', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@syncUpgradeConfigPrice");

    Route::post('idcsmart_jykj/host/:host_id/upgrade_config', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@upgradeConfig");

    Route::get('idcsmart_jykj/:id/log', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@log");
    
    // 更新主机配置
    Route::post('idcsmart_jykj/host/:host_id/updateconfig', "\\server\\idcsmart_jykj\\controller\\home\\IdcsmartJykjProductController@updateHostConfig");
})->allowCrossDomain([
    'Access-Control-Allow-Origin'        => $origin,
    'Access-Control-Allow-Credentials'   => 'true',
    'Access-Control-Max-Age'             => 600,
])->middleware(\app\http\middleware\CheckHome::class)
    ->middleware(\app\http\middleware\ParamFilter::class)
    ->middleware(\app\http\middleware\RejectRepeatRequest::class);

// 后台接口
Route::group(DIR_ADMIN . '/v1',function (){
    // 商品基础信息
	Route::get('idcsmart_jykj/product/:product_id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductController@index");
	// 保存商品基础信息
	Route::post('idcsmart_jykj/product/:product_id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductController@create");
	// 获取自定义周期详情
	Route::get('idcsmart_jykj/product/:product_id/custom_cycle/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductController@customCycle");
	// 添加自定义周期
	Route::post('idcsmart_jykj/product/:product_id/custom_cycle', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductController@createCustomCycle");
	// 修改自定义周期
	Route::put('idcsmart_jykj/product/:product_id/custom_cycle/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductController@updateCustomCycle");
	// 删除自定义周期
	Route::delete('idcsmart_jykj/product/:product_id/custom_cycle/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductController@deleteCustomCycle");

    Route::get('idcsmart_jykj/product/:product_id/module/:server_id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductController@getModuleConfig");

    // 配置项
    Route::get('idcsmart_jykj/product/:product_id/configoption', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductConfigoptionController@configoptionList");
    Route::post('idcsmart_jykj/product/:product_id/configoption/order', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductConfigoptionController@configoptionOrder");
    Route::get('idcsmart_jykj/product/:product_id/configoption/quantity', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductConfigoptionController@quantityConfigoption");
    Route::get('idcsmart_jykj/product/:product_id/configoption/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductConfigoptionController@index");
    Route::post('idcsmart_jykj/product/:product_id/configoption', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductConfigoptionController@create");
    Route::put('idcsmart_jykj/product/:product_id/configoption/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductConfigoptionController@update");
    Route::delete('idcsmart_jykj/product/:product_id/configoption/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductConfigoptionController@delete");
    Route::put('idcsmart_jykj/product/:product_id/configoption/:id/hidden', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductConfigoptionController@hidden");

    // 配置子项
    #Route::get('idcsmart_jykj/configoption/:configoption_id/sub', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductConfigoptionSubController@configoptionSubList");
    Route::get('idcsmart_jykj/configoption/:configoption_id/sub/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductConfigoptionSubController@index");
    Route::post('idcsmart_jykj/configoption/:configoption_id/sub', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductConfigoptionSubController@create");
    Route::post('idcsmart_jykj/configoption/:configoption_id/sub/order', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductConfigoptionSubController@subOrder");
    Route::put('idcsmart_jykj/configoption/:configoption_id/sub/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductConfigoptionSubController@update");
    Route::delete('idcsmart_jykj/configoption/:configoption_id/sub/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductConfigoptionSubController@delete");

    Route::get('idcsmart_jykj/host/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjHostController@index");
    Route::put('idcsmart_jykj/host/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjHostController@update");

    Route::get('idcsmart_jykj/product/:product_id/module', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductController@getModules");

    // 服务器分组
    Route::get('idcsmart_jykj/server_group', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjServerGroupController@serverGroupList");
    Route::get('idcsmart_jykj/server_group/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjServerGroupController@index");
    Route::post('idcsmart_jykj/server_group', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjServerGroupController@create");
    Route::put('idcsmart_jykj/server_group/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjServerGroupController@update");
    Route::delete('idcsmart_jykj/server_group/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjServerGroupController@delete");
    // 服务器
    Route::get('idcsmart_jykj/server', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjServerController@serverList");
    Route::get('idcsmart_jykj/server/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjServerController@index");
    Route::post('idcsmart_jykj/server', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjServerController@create");
    Route::put('idcsmart_jykj/server/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjServerController@update");
    Route::delete('idcsmart_jykj/server/:id', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjServerController@delete");
    Route::post('idcsmart_jykj/server/:id/status', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjServerController@testLink");
    Route::get('idcsmart_jykj/server/modules', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjServerController@getModules");
    // 周期比例
    Route::get('idcsmart_jykj/duration_ratio', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductController@indexDurationRatio");
    Route::put('idcsmart_jykj/duration_ratio', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductController@saveDurationRatio");
    Route::post('idcsmart_jykj/duration_ratio/fill', "\\server\\idcsmart_jykj\\controller\\admin\\IdcsmartJykjProductController@fillDurationRatio");

})->allowCrossDomain([
    'Access-Control-Allow-Origin'        => $origin,
    'Access-Control-Allow-Credentials'   => 'true',
    'Access-Control-Max-Age'             => 600,
])
    ->middleware(\app\http\middleware\CheckAdmin::class)
    ->middleware(\app\http\middleware\ParamFilter::class);