const template = document.getElementsByClassName("common-config")[0];
Vue.prototype.lang = Object.assign(window.lang, window.module_lang);
new Vue({
  components: {
    asideMenu,
    topMenu,
    payDialog,
    discountCode,
    eventCode,
    customGoods,
  },
  created() {
    //this.updateOsOptions();
    if (window.performance.navigation.type === 2) {
      sessionStorage.removeItem("product_information");
    }
    const params = getUrlParams();
    this.id = params.id;
    let temp = {};
    if (params.config || sessionStorage.getItem("product_information")) {
      try {
        temp = JSON.parse(params.config);
      } catch (e) {
        temp = JSON.parse(sessionStorage.getItem("product_information")) || {};
      }
    }

    // 回显配置
    if (temp && temp.config_options) {
      this.backfill = temp.config_options;
      this.configForm.config_options = temp.config_options;
      this.customfield = temp.customfield;
      this.self_defined_field = temp.self_defined_field || {};
      this.cycle = temp.config_options.cycle;
      this.orderData.qty = temp.qty;
      this.position = temp.position;
    }
    this.getCommonData();
    this.getGoodsName();
    this.getCountryList();
  },
  mounted() {
 

    this.packageList = [
      {
        id: 1,
        name: '基础套餐',
        cpunum: 2,
        memory: 4096,
        dayprice: 10.00,
        weekprice: 50.00,
        monthprice: 180.00,
        threemonthprice: 500.00,
        halfyearprice: 950.00,
        yearprice: 1800.00
      },
      {
        id: 2,
        name: '标准套餐',
        cpunum: 4,
        memory: 8192,
        dayprice: 20.00,
        weekprice: 100.00,
        monthprice: 360.00,
        threemonthprice: 1000.00,
        halfyearprice: 1900.00,
        yearprice: 3600.00
      },
      {
        id: 3,
        name: '高级套餐',
        cpunum: 8,
        memory: 16384,
        dayprice: 30.00,
        weekprice: 150.00,
        monthprice: 540.00,
        threemonthprice: 1500.00,
        halfyearprice: 2850.00,
        yearprice: 5400.00
      },
      {
        id: 4,
        name: '企业套餐',
        cpunum: 16,
        memory: 32768,
        dayprice: 40.00,
        weekprice: 200.00,
        monthprice: 720.00,
        threemonthprice: 2000.00,
        halfyearprice: 3800.00,
        yearprice: 7200.00
      },
      {
        id: 5,
        name: '旗舰套餐',
        cpunum: 32,
        memory: 65536,
        dayprice: 50.00,
        weekprice: 250.00,
        monthprice: 900.00,
        threemonthprice: 2500.00,
        halfyearprice: 4750.00,
        yearprice: 9000.00
      }
    ];
    this.addons_js_arr = JSON.parse(
      document.querySelector("#addons_js").getAttribute("addons_js")
    ); // 插件列表
    const arr = this.addons_js_arr.map((item) => {
      return item.name;
    });
    if (arr.includes("PromoCode")) {
      // 开启了优惠码插件
      this.isShowPromo = true;
    }
    if (arr.includes("IdcsmartClientLevel")) {
      // 开启了等级优惠
      this.isShowLevel = true;
    }
    if (arr.includes("EventPromotion")) {
      // 开启活动满减
      this.isShowFull = true;
    }
    if (arr.includes("EventPromotion")) {
      // 开启活动满减
      this.isShowFull = true;
    }
    this.getConfig();
    window.addEventListener("message", (event) => this.buyNow(event));
  },
  updated() {
    // 关闭loading
    document.getElementById("mainLoading").style.display = "none";
    document.getElementsByClassName("template")[0].style.display = "block";
    this.isShowBtn = true;
  },
  destroyed() {},
  computed: {
    calStr() {
      const temp = this.basicInfo.order_page_description
        ?.replace(/&lt;/g, "<")
        .replace(/&gt;/g, ">")
        .replace(/&quot;/g, '"')
        .replace(/&/g, "&")
        .replace(/"/g, '"')
        .replace(/'/g, "'");
      return temp;
    },
    calcDes() {
      return (val) => {
        const temp = val
          .replace(/&lt;/g, "<")
          .replace(/&gt;/g, ">")
          .replace(/&quot;/g, '"')
          .replace(/&/g, "&")
          .replace(/"/g, '"')
          .replace(/'/g, "'");
        return temp;
      };
    },
    calcSwitch() {
      return (item, type) => {
        if (type) {
          const arr = item.subs.filter((item) => item.option_name === lang.yes);
          return arr[0]?.id;
        } else {
          const arr = item.subs.filter((item) => item.option_name === lang.no);
          return arr[0]?.id;
        }
      };
    },
    calcCountry() {
      return (val) => {
        return this.countryList.filter((item) => val == item.iso)[0]?.name_zh;
      };
    },
    calcCity() {
      return (id) => {
  
        return this.filterCountry[id].filter(
          (item) => item[0]?.country === this.curCountry[id]
        )[0];
      };
    },
  },

  filters: {
    formateTime(time) {
      if (time && time !== 0) {
        return formateDate(time * 1000);
      } else {
        return "--";
      }
    },
    filterMoney(money) {
      if (isNaN(money) || money * 1 < 0) {
        return "0.00";
      } else {
        return formatNuberFiexd(money);
      }
    },
  },
  data() {
    return {
      packageList: [], // 存储获取的套餐数据
      id: "",
      goodsInfo: {},
      position: "",
      addons_js_arr: [], // 插件数组
      isShowPromo: false, // 是否开启优惠码
      isShowLevel: false, // 是否开启等级优惠
      isShowFull: false,
      is_show_custom: false,
      isUseDiscountCode: false, // 是否使用优惠码
      backfill: {}, // 回填参数
      customfield: {}, // 自定义字段
      self_defined_field: {}, // 自定义字段
      submitLoading: false,
      totalPrice: 0,
      commonData: {},
      eventData: {
        id: "",
        discount: 0,
      },
      // 订单数据
      orderData: {
        qty: 1,
        // 是否勾选阅读
        isRead: false,
        // 付款周期
        duration: "",
      },
      // 右侧展示区域
      showInfo: [],
      base_price: "",
      // 商品原单价
      onePrice: 0,
      // 商品原总价
      original_price: 0,

      timerId: null, // 订单id
      basicInfo: {}, // 基础信息
      configoptions: [], // 配置项
      custom_cycles: [], // 自定义周期
      curCycle: 0,
      cycle: "",
      onetime: "",
      pay_type: "",
      // 提交数据
      configForm: {
        // 自定义配置项
      },
      isShowBtn: false,
      // 国家列表
      countryList: [],
      // 处理过后的国家列表
      filterCountry: {},
      curCountry: {}, // 当前国家，根据配置id存入对应的初始索引
      cartDialog: false,
      dataLoading: false,
      selectOsObj: {},
      // 客户等级折扣金额
      clDiscount: 0,
      // 优惠码折扣金额
      code_discount: 0,
      osSelectData: [],
      osGroupId: "",
      osIcon: "",
      remainingInfo: "",
      selectedPackageId: null, // 当前选中的套餐 ID
      nodeOptions: [], // 动态获取的机房选项
      selectedNodeId: null, // 选中的机房ID
      selectedPackage: null, // 选中的套餐信息
      osOptions: [], // 动态获取的操作系统选项
      selectedOsId: null, // 选中的操作系统ID
      remainingType: 'success', // 默认是 success
    };
  },
  methods: {
        // 选择套餐的方法
  selectPackage(package) {
    this.selectedPackage=package;
    
    this.selectedPackageId = package.id; // 更新选中的套餐 ID
    
    // ===== 反向联动：根据卡片选择自动更新下拉框 =====
    // 从卡片名称提取套餐类型和编号
    // 如 "南京特价机房VPS（套餐一）" -> "特价套餐一"
    const packageName = package.name;
    
    // 提取套餐类型（特价、标准、高级）
    const typeMatch = packageName.match(/(特价|标准|高级)/);
    const packageType = typeMatch ? typeMatch[1] : '';
    
    // 提取套餐编号（套餐一、套餐二等）
    const numberMatch = packageName.match(/（(套餐[一二三四五六七八九十]+)）/);
    const packageNumber = numberMatch ? numberMatch[1] : '';
    
    // 如果成功提取到类型和编号，则更新下拉框
    if (packageType && packageNumber) {
      // 组合成下拉框选项名称，如 "特价套餐一"
      const targetOptionName = packageType + packageNumber;
      
      // 遍历配置项，找到套餐下拉框并设置对应的值
      this.configoptions.forEach((item) => {
        if (item.option_name === '套餐') {
          // 在该配置项的选项中查找匹配的选项
          const matchedSub = item.subs.find(sub => sub.option_name === targetOptionName);
          if (matchedSub) {
            // 更新下拉框的选中值
            this.$set(this.configForm, item.id, matchedSub.id);
          }
        }
      });
    }
    // ===== 反向联动结束 =====
    
    this.getNodeOptions(package.id);
    this.changeConfig();

  },
  // 判断操作系统是否禁用
  isOsDisabled(os) {
    // 如果没有选择套餐，不做判断
    if (!this.selectedPackage) return false;

    // 提取操作系统要求的内存（假设格式如 "win7-64位流畅版(内存需1G以上)"）
    const memoryRequirement = this.extractMemoryRequirement(os.name);
  
    // 如果没有内存要求，不禁用
    if (!memoryRequirement) return false;

    // 比较内存大小
    return this.selectedPackage.memory < memoryRequirement;
  },

  // 提取操作系统内存要求（例如 "1G" 转换为 1024MB）
  extractMemoryRequirement(osName) {
    const match = osName.match(/内存需(\d+)G以上/);
    if (match && match[1]) {
      return parseInt(match[1]) * 1024; // 将 G 转换为 MB
    }
    return null;
  },
  async onNodeChange() {
   
    if (this.selectedNodeId) {
      try { 
        // 发送请求到后端接口获取操作系统数据
        // const response = await this.$http.post('/idcsmart_jyvps/getVmosByNode', {
        //   node_id: this.selectedNodeId,
        // });
        const response = await getvmos(this.selectedNodeId);
        //console.log(response)
       
        if (response.data && response.data.errcode == 0) {
          this.osOptions = response.data.data; // 假设返回的数据结构为 { status: 'success', data: [...] }
        } else {
          this.osOptions = [];
          this.$message.error('获取操作系统数据失败');
        }
      } catch (error) {
        this.osOptions = [];
       
        this.$message.error('请求失败');
      }
    } else {
      this.osOptions = [];
    }
  },
  async getNodeOptions(packageId) {
    try {
      // 发送请求到后端接口
      const response = await getvmnode(packageId);
      
      const response2 = await getnodebyprdid(this.selectedPackageId);
  
      // 初始化总剩余数量
      let totalRemaining = 0;
      let prefix = '';
      let updatedData=response
      // 遍历数据并处理
      response2.data.msg.forEach(item => {
        // 提取剩余数量的数字
        const match = item.name.match(/剩余(\d+)台/);
        if (match && match[1]) {
          totalRemaining += parseInt(match[1]); // 将剩余数量加到总数
        }
        updatedData = response.data.data.map(item1 => {
          // 拼接字符串到 name 字段后面
          if (item.name2==item1.name){
            item1.name=item.name
          }
          return item1;
        });

        // 提取前缀（假设 name2 中有标识信息）
        if (!prefix && item.name2) {
          prefix = item.name2.split('-')[0]; // 提取例如 "黄山电信"
        }
      });

      // 拼接最终字符串，加上套餐名称
      // 从选中的套餐中提取套餐编号（如"套餐一"）
      let packageInfo = '';
      if (this.selectedPackage && this.selectedPackage.name) {
        const packageMatch = this.selectedPackage.name.match(/（(套餐[一二三四五六七八九十]+)）/);
        if (packageMatch && packageMatch[1]) {
          packageInfo = `（${packageMatch[1]}）`;
        }
      }
      
      // 添加提示：不同套餐库存可能不同
      const stockNote = packageInfo ? '（不同套餐库存可能不同）' : '';
      const result = `${prefix}${packageInfo}共剩余${totalRemaining}台${stockNote}`;
      
      
      this.remainingInfo=result
      if (totalRemaining <= 0) {
        this.remainingInfo = result;
        this.remainingType = 'error'; // 设置为 error 类型
        
        // 智能提示：建议选择其他套餐
        let suggestion = '，抱歉该地区没有机器了';
        if (packageInfo) {
          // 提取当前套餐编号
          const currentMatch = packageInfo.match(/套餐([一二三四五六七八九十]+)/);
          if (currentMatch) {
            suggestion = '，请尝试选择其他套餐（如套餐二、套餐三等），不同套餐库存独立';
          }
        }
        
        // Element UI 弹窗提示
        this.$message.error(result + suggestion);
        this.nodeOptions = [];
        return;
      } else {
        this.$message.success(result);
        this.remainingType = 'success'; // 设置为 success 类型
      }
      if (response.data && response.data.errcode ==0) {
        // 使用 map 方法遍历数组并修改 name 字段
      //  const updatedData = response.data.data.map(item => {
      //     // 拼接字符串到 name 字段后面
      //     item.name = item.name + result;
      //     return item;
      //   }); 
        this.nodeOptions = updatedData; 
      } else {
        this.nodeOptions = [];
        this.$message.error('获取机房数据失败');
      }
    } catch (error) {
      
      this.nodeOptions = [];
      this.$message.error('请求失败');
    }
  },
  
    getGoodsName() {
      productInfo(this.id).then((res) => {
        this.goodsInfo = res.data.data.product;
        document.title =
          this.commonData.website_name + "-" + res.data.data.product.name;
      });
    },
    // 解析url
    getQuery(url) {
      const str = url.substr(url.indexOf("?") + 1);
      const arr = str.split("&");
      const res = {};
      for (let i = 0; i < arr.length; i++) {
        const item = arr[i].split("=");
        res[item[0]] = item[1];
      }
      return res;
    },
    async getCountryList() {
      try {
        const res = await getCountry();
    
        const res1 = await getPrience();
        
        this.countryList = res1.data.msg;
       

      } catch (error) {}
    },
    // 镜像分组改变时
    osSelectGroupChange(e, item) {
      const obj = item.subs.filter((sub) => sub.os === this.osGroupId)[0];
      this.osSelectData = obj.version;
      this.osIcon =
        "/plugins/server/idcsmart_jyvps/template/clientarea/pc/default/img/idcsmart_jyvps/" +
        obj.os +
        ".svg";
      this.configForm[item.id] = obj.version[0].id;
      this.changeConfig();
    },
    eventChange(evetObj) {
      if (this.eventData.id !== evetObj.id) {
        this.eventData.id = evetObj.id || "";
        this.customfield.event_promotion = this.eventData.id;
        this.changeConfig();
      }
    },
    // 镜像版本改变时
    osSelectChange() {
      this.changeConfig();
    },
    async getConfig() {
      try {
        const res = await getCommonDetail(this.id);
        const temp = res.data.data;
        this.basicInfo = temp.common_product;
        this.configoptions = temp.configoptions.filter(
          (item) => item.subs.length
        );
        this.custom_cycles = temp.custom_cycles;
        this.pay_type = temp.common_product.pay_type;
        this.onetime =
          temp.cycles.onetime === "-1.00" ? "0.00" : temp.cycles.onetime;
        // 初始化自定义配置参数
        const obj = this.configoptions.reduce((all, cur) => {
          all[cur.id] =
            cur.option_type === "multi_select" ||
            cur.option_type === "quantity" ||
            cur.option_type === "quantity_range"
              ? [
                  cur.option_type === "multi_select"
                    ? cur.subs[0].id
                    : cur.subs[0].qty_min,
                ]
              : cur.subs[0].id;
          // 区域的时候保存国家
          if (cur.option_type === "area") {
           
            this.filterCountry[cur.id] = this.toTree(cur.subs);
    
            this.fetchPackageList2(this.filterCountry[cur.id][0][0].id);
            //
           
            const cityText = this.filterCountry[cur.id][0][0].option_name;
      // 使用正则提取括号中的标签，如 '特价' 或 '标准'
      const match = cityText.match(/（(.*?)）/);
      const label = match ? match[1] : '';
      

      
        // 遍历 configoptions，找到所有下拉框类型的项
        this.configoptions.forEach((item) => {
          // 只处理类型为 'select' 或 'multi_select' 的项
          if (item.option_type === 'select' || item.option_type === 'multi_select') {
            // 确保每次切换时都重新过滤
            // 如果没有保存原始的 subs 数据，需要保存它
            if (!item.originalSubs) {
              item.originalSubs = [...item.subs];  // 保存原始的选项数据
            }

            // 根据标签过滤下拉框的选项
            const filteredOptions = this.filterOptionsByLabel(label, item);

            // 更新该下拉框的选项
            item.subs = filteredOptions;

            // 重置选中的值，避免与新选项冲突
            this.configForm[item.id] = null;
          }
        });

           
            this.$set(this.curCountry, cur.id, 0);
          }

          if (cur.option_type === "os") {
            this.osGroupId = cur.subs[0].os;
            this.osSelectData = cur.subs[0].version;
            all[cur.id] = cur.subs[0].version[0].id;
            this.osIcon =
              "/plugins/server/idcsmart_jyvps/template/clientarea/pc/default/img/idcsmart_jyvps/" +
              cur.subs[0].os +
              ".svg";
          }
          return all;
        }, {});
        this.configForm = obj;
        if (this.pay_type === "onetime") {
          this.cycle = "onetime";
        } else if (this.pay_type === "free") {
          this.cycle = "free";
        } else {
          this.cycle = temp.custom_cycles[0].id;
        }

        // this.changeConfig()
        this.changeConfig(this.backfill.cycle ? true : false);
      } catch (error) {}
    },
    // 数组转树
    toTree(data) {
      var temp = Object.values(
        data.reduce((res, item) => {
          res[item.country]
            ? res[item.country].push(item)
            : (res[item.country] = [item]);
          return res;
        }, {})
      );
      return temp;
    },
    updateOsOptions() {
      this.osOptions = this.osOptions.map((os) => {
        return {
          ...os,
          disabled: this.isOsDisabled(os) // 更新禁用状态
        };
      });
    },
    // 切换配置选项
    changeItem(item) {
      // 根据选择的套餐ID来找到对应的套餐信息
      const selectedOptionText = item.subs.find(el => el.id == this.configForm[item.id]).option_name; // 获取选中的文本，例如"套餐一"
      
      // 通过文本匹配找到对应的套餐
      const lastThreeChars = selectedOptionText.slice(-3); // 获取最后三个字符
      const selectedPackage = this.packageList.find(pkg => pkg.name.includes(lastThreeChars));
      
      if (selectedPackage) {
        this.selectedPackageId = selectedPackage.id; // 更新选中的套餐 ID
        this.selectedPackage=selectedPackage;
        this.getNodeOptions(selectedPackage.id);
        this.updateOsOptions();
      }else{
             this.$message.warning("没有该套餐")
             setTimeout(function() {
              location.reload();
            }, 1000); 
      }
      
      this.changeConfig();
    },
    // 使用优惠码
    getDiscount(data) {
      this.customfield.promo_code = data[1];
      this.isUseDiscountCode = true;
      this.changeConfig();
    },
    // 更改配置计算价格
    async changeConfig(bol = false) {
      try {
        if (bol) {
          /* 处理 quantity quantity_range  */
          const _temp = this.backfill.configoption;
          Object.keys(_temp).forEach((item) => {
            const type = this.configoptions.filter((el) => el.id === item)[0]
              ?.option_type;
            if (type === "quantity" || type === "quantity_range") {
              _temp[item] = _temp[item][0];
            }
          });
          this.configForm = _temp;
          this.cycle = this.backfill.cycle;
          this.curCycle = this.custom_cycles.findIndex(
            (item) => item.id * 1 === this.cycle * 1
          );
        }
        const temp = this.formatData();

        const params = {
          id: this.id,
          config_options: {
            configoption: temp,
            cycle: this.cycle,
            promo_code: this.customfield.promo_code,
            event_promotion: this.customfield.event_promotion,
          },
          qty: this.orderData.qty,
        };
        this.dataLoading = true;
        const res = await calcPrice(params);

        this.original_price = res.data.data.price * 1;
        this.totalPrice = res.data.data.price_total * 1;
        this.clDiscount = res.data.data.price_client_level_discount * 1 || 0;
        this.code_discount = res.data.data.price_promo_code_discount * 1 || 0;
        this.eventData.discount =
          res.data.data.price_event_promotion_discount * 1 || 0;

        this.base_price = res.data.data.base_price;
        this.showInfo = res.data.data.preview;
        this.onePrice = res.data.data.price; // 原单价
        this.orderData.duration = res.data.data.duration;

        // 重新计算周期显示
        const result = await calculate(params);
        this.custom_cycles = result.data.data.custom_cycles;
        this.onetime = result.data.data.cycles.onetime;
        this.dataLoading = false;
      } catch (error) {
        this.dataLoading = false;
      }
    },
    removeDiscountCode() {
      this.isUseDiscountCode = false;
      this.customfield.promo_code = "";
      this.code_discount = 0;
      this.changeConfig();
    },
 

    changeCountry(id, index) {
      this.packageList = [];
      this.selectedPackageId= null;
      this.selectedNodeId= null;
      this.selectedOsId= null;
      this.nodeOptions = [];
      this.osOptions = [];
      this.remainingInfo="";

      this.$set(this.curCountry, id, index);
      this.configForm[id] = this.filterCountry[id][index][0]?.id;

    
      const cityText = this.filterCountry[id][index][0]?.option_name;
      
      // 使用正则提取括号中的标签，如 '特价' 或 '标准'
      const match = cityText.match(/（(.*?)）/);
      const label = match ? match[1] : '';
      
      this.configoptions.forEach((item) => {
        // 只处理类型为 'select' 或 'multi_select' 的项
        if (item.option_type === 'select' || item.option_type === 'multi_select') {
          // 确保每次切换时都重新过滤
          // 如果没有保存原始的 subs 数据，需要保存它
          if (!item.originalSubs) {
            item.originalSubs = [...item.subs];  // 保存原始的选项数据
          }
  
          // 根据标签过滤下拉框的选项
          const filteredOptions = this.filterOptionsByLabel(label, item);
  
          // 更新该下拉框的选项
          item.subs = filteredOptions;
  
          // 重置选中的值，避免与新选项冲突
          // 选择第一个选项而不是清空
        if (item.subs.length > 0) {
          this.configForm[item.id] = item.subs[0].id;
        } else {
          this.configForm[item.id] = null; // 如果没有可选项，则设置为 null
        }
        }
      });

      this.fetchPackageList(this.configForm[id]);
      
      this.changeConfig();
    },
    // 切换城市
    changeCity(el, id) {
      this.packageList = [];
      this.selectedPackageId= null;
      this.selectedNodeId= null;
      this.selectedOsId= null;
      this.nodeOptions = [];
      this.osOptions = [];
      this.remainingInfo="";
      this.configForm[id] = el.id;
      const cityText = el.option_name;
      
      // 使用正则提取括号中的标签，如 '特价' 或 '标准'
      const match = cityText.match(/（(.*?)）/);
      const label = match ? match[1] : '';
     

        // 遍历 configForm，找到所有下拉框类型的项
        // 遍历 configoptions，找到所有下拉框类型的项
    this.configoptions.forEach((item) => {
      // 只处理类型为 'select' 或 'multi_select' 的项
      if (item.option_type === 'select' || item.option_type === 'multi_select') {
        // 确保每次切换时都重新过滤
        // 如果没有保存原始的 subs 数据，需要保存它
        if (!item.originalSubs) {
          item.originalSubs = [...item.subs];  // 保存原始的选项数据
        }

        // 根据标签过滤下拉框的选项
        const filteredOptions = this.filterOptionsByLabel(label, item);

        // 更新该下拉框的选项
        item.subs = filteredOptions;

        // 重置选中的值，避免与新选项冲突
        // 选择第一个选项而不是清空
      if (item.subs.length > 0) {
        this.configForm[item.id] = item.subs[0].id;
      } else {
        this.configForm[item.id] = null; // 如果没有可选项，则设置为 null
      }
      }
    });

    // 获取对应城市的套餐数据
    this.fetchPackageList(el.id);
    this.changeConfig();
  },

  filterOptionsByLabel(label, item) {
    if (!item || !item.originalSubs) return [];

    // 每次都从原始的 subs 数据中进行过滤
    return item.originalSubs.filter(sub => sub.option_name.includes(label));
  },
  async fetchPackageList(cityId) {
    try {
      const res = await getvmproduct(cityId);

      
  
      if (res && res.data.errcode === 0) {
        // 更新套餐列表
        this.packageList = res.data.data;
  
        // 初始化一个变量来存储选中的套餐名称
        let selectedPackageName = null;
  
        // 遍历 configoptions，找到第一个匹配的选项值
        this.configoptions.forEach((item) => {
          if (item.option_type === 'select' || item.option_type === 'multi_select') {
            // 获取当前选中的值
            const selectedOptionId = this.configForm[item.id];
  
            // 在 subs 中找到对应的选中项
            const selectedOption = item.subs.find(option => option.id === selectedOptionId);
  
            if (selectedOption) {
              // 取选中项的文本值
              const selectedOptionText = selectedOption.option_name;
              // 提取文本值中的后三个字符，如 '套餐几'
              const packageNumber = selectedOptionText.slice(-3);
            
  
              // 在套餐列表中查找匹配的套餐
              const matchedPackage = this.packageList.find(pkg => pkg.name.includes(packageNumber));
  
              if (matchedPackage) {
                selectedPackageName = matchedPackage.name;
                this.selectedPackageId = matchedPackage.id;
                this.selectedPackage = matchedPackage;
              }
            }
          }
        });
  
        // 如果找不到匹配的套餐，就默认选择第一个套餐
        if (!selectedPackageName && this.packageList.length > 0) {
          this.selectedPackageId = this.packageList[0].id;
          this.selectedPackage = this.packageList[0];
        }
  
        // 根据选中的套餐获取节点选项
        if (this.selectedPackageId) {
          this.getNodeOptions(this.selectedPackageId);
        }
      } else {
        this.packageList = [];
        console.error('获取套餐数据失败:', res.errmsg);
      }
    } catch (error) {
      console.error('获取套餐数据失败:', error);
    }
  },
  
    async fetchPackageList2(cityId) {
      try {
        const res = await getvmproduct(cityId);
       
      
        if (res && res.data.errcode === 0) {
          // 处理数据
          this.packageList = res.data.data; // 更新套餐列表
          this.selectedPackageId = this.packageList[0].id;
          this.selectedPackage=this.packageList[0];
          this.getNodeOptions(this.packageList[0].id);

        } else {
          this.packageList = [];
          console.error('获取套餐数据失败:', res.errmsg);
        }
      } catch (error) {
        console.error('获取套餐数据失败:', error);
      }
    },
     // 获取套餐数据
    //  fetchPackageList(cityId) {

    //   // 调用后端接口，传入城市ID
    //   axios.get(`/idcsmart_jyvps/getvmproduct?city_id=${cityId}`)
    //     .then(response => {
    //       if (response.data && response.data.errcode === 0) {
    //        
    //       } else {
    //        
    //       }
    //     })
    //     .catch(error => {
    //       console.error('获取套餐数据失败:', error);
    //       this.packageList = [];
    //     });
    // },

      // getvmproduct(cityId)
      //   .then(response => {
      //     if (response.data && response.data.errcode === 0) {
      //       this.packageList = response.data.data; // 更新套餐列表
      //     } else {
      //       this.packageList = [];
      //     }
      //   })
      //   .catch(error => {
      //     console.error('获取套餐数据失败:', error);
      //     this.packageList = [];
      //   });
    // },
  
    // 切换单击选择
    changeClick(id, el) {
     
      this.configForm[id] = el.id;
       // 获取选中的单选框文本值
    

      this.changeConfig();
    },
    // 切换数量
    changeNum(val, id) {
      this.configForm[id] = [val * 1];
      this.changeConfig();
    },
    // 切换周期
    changeCycle(item, index) {
      this.cycle = item.id;
      this.curCycle = index;
      this.changeConfig();
    },
    // 商品购买数量减少
    delQty() {
      if (this.basicInfo.allow_qty === 0) {
        return false;
      }
      if (this.orderData.qty > 1) {
        this.orderData.qty--;
        this.changeConfig();
      }
    },
    // 商品购买数量增加
    addQty() {
      if (this.basicInfo.allow_qty === 0) {
        return false;
      }
      this.orderData.qty++;
      this.changeConfig();
    },

    formatData() {

      // 处理数量类型的转为数组
      const temp = JSON.parse(JSON.stringify(this.configForm));
      
      Object.keys(temp).forEach((el) => {
        const arr = this.configoptions.filter((item) => item.id * 1 === el * 1);
        if (
          arr[0].option_type === "quantity" ||
          arr[0].option_type === "quantity_range" ||
          arr[0].option_type === "multi_select"
        ) {
          if (typeof temp[el] !== "object") {
            temp[el] = [temp[el]];
          }
        }
      });
      return temp;
    },
    // 立即购买
    /*
    selectedPackageId: null, // 当前选中的套餐 ID
    selectedNodeId: null, // 选中的机房ID
    selectedOsId: null, // 选中的操作系统ID
    */
    async buyNow(e) {
      
      // const password=this.self_defined_field.find(
      //   (item) => item.field_name === 'VPS_云服务器密码'
      // );
     
      // return;
      if (!this.selectedNodeId){
        this.$message.warning("选择机房")
        return;
      }
      if (!this.selectedOsId){
        this.$message.warning("选择系统")
        return;
      }
      if (e.data && e.data.type !== "iframeBuy") {
        return;
      }
      if (
        Boolean(
          (JSON.parse(localStorage.getItem("common_set_before")) || {})
            .custom_fields?.before_settle === 1
        )
      ) {
        window.open("/account.htm");
        return;
      }
      const flag = this.$refs.customGoodRef.getSelfDefinedField();
      if (!flag) return;
      
      const temp = this.formatData();
      const params = {
        product_id: this.id,
        config_options: {
        configoption: temp,
        cycle: this.cycle,
        taocanid: this.selectedPackageId,
        nodeid: this.selectedNodeId,
        osid: this.selectedOsId
        },
        qty: this.orderData.qty,
        customfield: this.customfield,
        self_defined_field: this.self_defined_field,
        

      };
      
      // ===== 套餐匹配验证 =====
      if (this.selectedPackageId && temp) {
        try {
          const validateParams = {
            taocanid: this.selectedPackageId,
            configoption: temp
          };
          const validateRes = await validatePackage(validateParams);
          if (validateRes.data.status !== 200) {
            this.$message.error(validateRes.data.msg);
            return;
          }
        } catch (error) {
          this.$message.error('套餐验证失败，请重试');
          return;
        }
      }
      // ===== 套餐匹配验证结束 =====
      
      // 直接传配置到结算页面
      if (e.data && e.data.type === "iframeBuy") {
        const postObj = { type: "iframeBuy", params, price: this.totalPrice };
        window.parent.postMessage(postObj, "*");
        return;
      }
      location.href = `/cart/settlement.htm?id=${params.product_id}`;
      sessionStorage.setItem("product_information", JSON.stringify(params));
    },
    // 加入购物车
    async addCart() {
      
      
      if (!this.selectedNodeId){
        this.$message.warning("选择机房")
        return;
      }
      if (!this.selectedOsId){
        this.$message.warning("选择系统")
        return;
      }
      // if (!this.orderData.isRead) {
      //   this.$message.warning("请先阅读并勾选协议")
      //   return false
      // }
      try {
        const flag = this.$refs.customGoodRef.getSelfDefinedField();
        if (!flag) return;
        const temp = this.formatData();
        const params = {
          product_id: this.id,
          config_options: {
            configoption: temp,
            cycle: this.cycle,
            taocanid: this.selectedPackageId,
            nodeid: this.selectedNodeId,
            osid: this.selectedOsId
          },
          qty: this.orderData.qty,
          customfield: this.customfield,
          self_defined_field: this.self_defined_field,
         
        };
        
        // ===== 套餐匹配验证 =====
        if (this.selectedPackageId && temp) {
          const validateParams = {
            taocanid: this.selectedPackageId,
            configoption: temp
          };
          const validateRes = await validatePackage(validateParams);
          if (validateRes.data.status !== 200) {
            this.$message.error(validateRes.data.msg);
            return;
          }
        }
        // ===== 套餐匹配验证结束 =====
        
        const res = await addToCart(params);
        if (res.data.status === 200) {
          this.cartDialog = true;
          const result = await getCart();
          localStorage.setItem(
            "cartNum",
            "cartNum-" + result.data.data.list.length
          );
        }
      } catch (error) {
        this.$message.error(error.data.msg);
      }
    },
    // 修改购物车
    async changeCart() {
      try {
        const flag = this.$refs.customGoodRef.getSelfDefinedField();
        if (!flag) return;
        const temp = this.formatData();
        const params = {
          position: this.position,
          product_id: this.id,
          config_options: {
            configoption: temp,
            cycle: this.cycle,
          },
          qty: this.orderData.qty,
          customfield: this.customfield,
          self_defined_field: this.self_defined_field,
        };
        this.dataLoading = true;
        const res = await updateCart(params);
        this.$message.success(res.data.msg);
        setTimeout(() => {
          location.href = "/cart/shoppingCar.htm";
        }, 300);
        this.dataLoading = false;
      } catch (error) {
      
        this.$message.error(error.data.msg);
      }
    },
    goToCart() {
      location.href = "/cart/shoppingCar.htm";
      this.cartDialog = false;
    },
    // 支付成功回调
    paySuccess(e) {
      this.submitLoading = false;
      location.href = "common_product_list.htm";
    },
    // 取消支付回调
    payCancel(e) {
      this.submitLoading = false;
      location.href = "finance.htm";
    },
    // 获取通用配置
    getCommonData() {
      this.commonData = JSON.parse(localStorage.getItem("common_set_before"));

      document.title =
        this.commonData.website_name + "-" + lang.common_cloud_text109;
    },
  },
}).$mount(template);
