<?php 

use think\facade\Route;

$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';

// 不需要登录
Route::group('console/v1',function (){
    
    Route::get('idcsmart_jyvps/product/:product_id/configoption', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@cartConfigoption");
    Route::post('idcsmart_jyvps/product/:product_id/configoption/calculate', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@cartConfigoptionCalculate");
    Route::post('idcsmart_jyvps/validate_package', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@validatePackageMatch");
})->allowCrossDomain([
    'Access-Control-Allow-Origin'        => $origin,
    'Access-Control-Allow-Credentials'   => 'true',
    'Access-Control-Max-Age'             => 600,
])->middleware(\app\http\middleware\Check::class);

// 前台需要登录的接口
Route::group('console/v1',function (){
    
	Route::get('idcsmart_jyvps/host', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@hostList");

    Route::get('idcsmart_jyvps/host/:host_id/configoption', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@hostConfigotpion");
    Route::get('idcsmart_jyvps/host/:host_id/vpsconfigoption', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@hostVpsconfigoption");
    //vpsconfigoption

    Route::get('idcsmart_jyvps/host/:host_id/configoption/area', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@clientAreaOutput");
    Route::post('idcsmart_jyvps/host/:host_id/configoption/chart', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@chartData");
    Route::post('idcsmart_jyvps/host/:host_id/provision/status', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@provisionFuncStatus");
    Route::post('idcsmart_jyvps/host/:host_id/provision/:func', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@provisionFunc")->middleware(\app\http\middleware\CheckClientOperatePassword::class);
    Route::post('idcsmart_jyvps/host/:host_id/custom/provision', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@provisionFuncCustom");
    Route::get('idcsmart_jyvps/prience', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerGroupController@prience");
    Route::get('idcsmart_jyvps/:city_id/getvmproduct', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerGroupController@getVmProductByCity");
    Route::get('idcsmart_jyvps/host/:host_id/upgrade', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@upgradePage");
    Route::get('idcsmart_jyvps/:city_id/getVmNodeByProduct', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerGroupController@getVmNodeByProduct");
    Route::get('idcsmart_jyvps/:city_id/getVmosByNode', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerGroupController@getVmosByNode");
    Route::get('idcsmart_jyvps/:city_id/getnodebyprdid', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerGroupController@getnodebyprdid");
    Route::get('idcsmart_jyvps/:vmname/getvminfo', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerGroupController@getvminfo");
    Route::post('idcsmart_jyvps/host/:host_id/sync_upgrade_price', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@syncUpgradePrice");
//getVmosByNode  getnodebyprdid  getvminfo
    Route::post('idcsmart_jyvps/host/:host_id/upgrade', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@upgrade");

    Route::get('idcsmart_jyvps/host/:host_id/upgrade_config', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@upgradeConfigPage");

    Route::post('idcsmart_jyvps/host/:host_id/sync_upgrade_config_price', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@syncUpgradeConfigPrice");

    Route::post('idcsmart_jyvps/host/:host_id/upgrade_config', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@upgradeConfig");

    Route::get('idcsmart_jyvps/:id/log', "\\server\\idcsmart_jyvps\\controller\\home\\IdcsmartJyvpsProductController@log");
    

})->allowCrossDomain([
    'Access-Control-Allow-Origin'        => $origin,
    'Access-Control-Allow-Credentials'   => 'true',
    'Access-Control-Max-Age'             => 600,
])->middleware(\app\http\middleware\CheckHome::class)
    ->middleware(\app\http\middleware\ParamFilter::class)
    ->middleware(\app\http\middleware\RejectRepeatRequest::class);

// 后台接口
Route::group(DIR_ADMIN . '/v1',function (){
    // 商品基础信息
	Route::get('idcsmart_jyvps/product/:product_id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductController@index");
	// 保存商品基础信息
	Route::post('idcsmart_jyvps/product/:product_id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductController@create");
	// 获取自定义周期详情
	Route::get('idcsmart_jyvps/product/:product_id/custom_cycle/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductController@customCycle");
	// 添加自定义周期
	Route::post('idcsmart_jyvps/product/:product_id/custom_cycle', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductController@createCustomCycle");
	// 修改自定义周期
	Route::put('idcsmart_jyvps/product/:product_id/custom_cycle/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductController@updateCustomCycle");
	// 删除自定义周期
	Route::delete('idcsmart_jyvps/product/:product_id/custom_cycle/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductController@deleteCustomCycle");

    Route::get('idcsmart_jyvps/product/:product_id/module/:server_id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductController@getModuleConfig");

    // 配置项
    Route::get('idcsmart_jyvps/product/:product_id/configoption', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductConfigoptionController@configoptionList");
    Route::post('idcsmart_jyvps/product/:product_id/configoption/order', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductConfigoptionController@configoptionOrder");
    Route::get('idcsmart_jyvps/product/:product_id/configoption/quantity', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductConfigoptionController@quantityConfigoption");
    Route::get('idcsmart_jyvps/product/:product_id/configoption/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductConfigoptionController@index");
    Route::post('idcsmart_jyvps/product/:product_id/configoption', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductConfigoptionController@create");
    Route::put('idcsmart_jyvps/product/:product_id/configoption/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductConfigoptionController@update");
    Route::delete('idcsmart_jyvps/product/:product_id/configoption/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductConfigoptionController@delete");
    Route::put('idcsmart_jyvps/product/:product_id/configoption/:id/hidden', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductConfigoptionController@hidden");
  //获取省份
    
    // 配置子项
    #Route::get('idcsmart_jyvps/configoption/:configoption_id/sub', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductConfigoptionSubController@configoptionSubList");
    Route::get('idcsmart_jyvps/configoption/:configoption_id/sub/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductConfigoptionSubController@index");
    Route::post('idcsmart_jyvps/configoption/:configoption_id/sub', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductConfigoptionSubController@create");
    Route::post('idcsmart_jyvps/configoption/:configoption_id/sub/order', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductConfigoptionSubController@subOrder");
    Route::put('idcsmart_jyvps/configoption/:configoption_id/sub/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductConfigoptionSubController@update");
    Route::delete('idcsmart_jyvps/configoption/:configoption_id/sub/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductConfigoptionSubController@delete");

    Route::get('idcsmart_jyvps/host/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsHostController@index");
    Route::put('idcsmart_jyvps/host/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsHostController@update");

  

    Route::get('idcsmart_jyvps/product/:product_id/module', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductController@getModules");
    Route::get('idcsmart_jyvps/prience', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerGroupController@prience");
    // 服务器分组
    Route::get('idcsmart_jyvps/server_group', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerGroupController@serverGroupList");
    Route::get('idcsmart_jyvps/server_group/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerGroupController@index");
    Route::post('idcsmart_jyvps/server_group', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerGroupController@create");
    Route::put('idcsmart_jyvps/server_group/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerGroupController@update");
    Route::delete('idcsmart_jyvps/server_group/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerGroupController@delete");
    // 服务器
    Route::get('idcsmart_jyvps/server', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerController@serverList");
    Route::get('idcsmart_jyvps/server/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerController@index");
    Route::post('idcsmart_jyvps/server', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerController@create");
    Route::put('idcsmart_jyvps/server/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerController@update");
    Route::delete('idcsmart_jyvps/server/:id', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerController@delete");
    Route::post('idcsmart_jyvps/server/:id/status', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerController@testLink");
    Route::get('idcsmart_jyvps/server/modules', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsServerController@getModules");
    // 周期比例
    Route::get('idcsmart_jyvps/duration_ratio', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductController@indexDurationRatio");
    Route::put('idcsmart_jyvps/duration_ratio', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductController@saveDurationRatio");
    Route::post('idcsmart_jyvps/duration_ratio/fill', "\\server\\idcsmart_jyvps\\controller\\admin\\IdcsmartJyvpsProductController@fillDurationRatio");

})->allowCrossDomain([
    'Access-Control-Allow-Origin'        => $origin,
    'Access-Control-Allow-Credentials'   => 'true',
    'Access-Control-Max-Age'             => 600,
])
    ->middleware(\app\http\middleware\CheckAdmin::class)
    ->middleware(\app\http\middleware\ParamFilter::class);