<?php 
namespace server\idcsmart_jyvps\model;

use think\Model;

class IdcsmartJyvpsVmProductModel extends Model
{
    // 设置表名
    protected $name = 'module_idcsmart_jyvps_vmproduct';

    // 设置字段信息
    protected $schema = [
        'id'                       => 'int',
        'name'                     => 'string',
        'cpunum'                   => 'int',
        'memory'                   => 'int',
        'product_configoption_sub_id' => 'int',
        'vmnodeid'                 => 'string',
        'city'                        => 'int',
    ];

    /**
     * 插入新产品信息
     *
     * @param array $param 产品参数
     * @return int 返回新插入的产品ID
     */
    public function insertProduct($param)
    {
        $id = $this->insertGetId([
            'name' => $param['name'],
            'cpunum' => $param['cpunum'],
            'memory' => $param['memory'],
            'dayprice' => $param['dayprice'],
            'weekprice' => $param['weekprice'],
            'monthprice' => $param['monthprice'],
            'threemonthprice' => $param['threemonthprice'],
            'halfyearprice' => $param['halfyearprice'],
            'yearprice' => $param['yearprice'],
            'product_configoption_sub_id' => $param['product_configoption_sub_id'],
            'vmnodeid' => $param['vmnodeid'],
        ]);

        return $id;
    }

    /**
     * 更新产品信息
     *
     * @param int $id 产品ID
     * @param array $param 更新参数
     * @return bool 更新结果
     */
    public function updateProduct($id, $param)
    {
        $data = [
            'name' => $param['name'],
            'cpunum' => $param['cpunum'],
            'memory' => $param['memory'],
            'dayprice' => $param['dayprice'],
            'weekprice' => $param['weekprice'],
            'monthprice' => $param['monthprice'],
            'threemonthprice' => $param['threemonthprice'],
            'halfyearprice' => $param['halfyearprice'],
            'yearprice' => $param['yearprice'],
            'product_configoption_sub_id' => $param['product_configoption_sub_id'],
            'vmnodeid' => $param['vmnodeid'],
           
        ];

        return $this->where('id', $id)->update($data);
    }

    /**
     * 根据ID删除产品信息
     *
     * @param int $id 产品ID
     * @return bool 删除结果
     */
    public function deleteProduct($id)
    {
        return $this->where('id', $id)->delete();
    }

    /**
     * 获取所有产品信息
     *
     * @return array 返回产品列表
     */
    public function getAllProducts()
    {
        return $this->select()->toArray();
    }

    /**
     * 根据ID获取产品信息
     *
     * @param int $id 产品ID
     * @return array|null 产品信息
     */
    public function getProductById($id)
    {
        return $this->where('id', $id)->find();
    }
}
