<?php
namespace server\idcsmart_jyvps\controller\admin;

use app\event\controller\BaseController;
use app\common\model\ServerModel;
use server\idcsmart_jyvps\model\IdcsmartJyvpsServerGroupModel;
use server\idcsmart_jyvps\validate\IdcsmartJyvpsServerGroupValidate;
use server\idcsmart_jyvps\model\IdcsmartJyvpsVmProductModel;
use server\idcsmart_jyvps\model\IdcsmartJyvpsVmNodeModel;
use server\idcsmart_jyvps\model\IdcsmartJyvpsVmOsModel;
use server\idcsmart_jyvps\model\IdcsmartJyvpsProductConfigoptionSubModel;
use server\idcsmart_jyvps\model\IdcsmartJyvpsCustomCycleModel;
use server\idcsmart_jyvps\model\IdcsmartJyvpsCustomCyclePricingModel;
//IdcsmartJyvpsVmOsModel  IdcsmartJyvpsVmNameModel  IdcsmartJyvpsProductConfigoptionSubModel IdcsmartJyvpsVmProductModel IdcsmartJyvpsCustomCycleModel


/**
 * @title 通用商品-子接口
 * @desc 通用商品-子接口
 * @use server\idcsmart_jyvps\controller\admin\IdcsmartJyvpsServerGroupController
 */
class IdcsmartJyvpsServerGroupController extends BaseController{

    /**
     * 时间 2023-6-8
     * @title 服务器分组列表
     * @desc 服务器分组列表
     * @url /admin/v1/idcsmart_jyvps/server_group
     * @method  GET
     * @author zn
     * @version v1
     * @param string modules - 模块，非必传
     * @return array list - 服务器分组列表
     * @return int list[].id - 服务器分组ID
     * @return string list[].name - 服务器分组名称
     * @return int list[].num - 总数量
     * @return int list[].used - 使用
     * @return int list[].mode - 分配方式(1:平均分配;2:满一个算一个(这两个分配方式写死))
     * @return int count - 数量
     */
    public function serverGroupList(){
        // 合并分页参数
        $param = array_merge($this->request->param(), ['page' => $this->request->page, 'limit' => $this->request->limit, 'sort' => $this->request->sort]);

        $IdcsmartJyvpsServerGroupModel = new IdcsmartJyvpsServerGroupModel();

        $result = $IdcsmartJyvpsServerGroupModel->serverGroupList($param);

        return json($result);
    }

    /**
     * 时间 2023-6-8
     * @title 添加服务器分组
     * @desc 添加服务器分组
     * @url /admin/v1/idcsmart_jyvps/server_group
     * @method  POST
     * @author zn
     * @version v1
     * @param string name - 服务器分组名称 required
     * @param string mode - 分配方式(1:平均分配;2:满一个算一个(这两个分配方式写死)) required
     * @param array server_ids - 选择的服务器ID,数组
     */
    public function create(){
        $param = $this->request->param();

        $IdcsmartJyvpsServerGroupValidate = new IdcsmartJyvpsServerGroupValidate();
        if (!$IdcsmartJyvpsServerGroupValidate->scene('create')->check($param)){
            return json(['status'=>400,'msg'=>$IdcsmartJyvpsServerGroupValidate->getError()]);
        }

        $IdcsmartJyvpsServerGroupModel = new IdcsmartJyvpsServerGroupModel();

        $result = $IdcsmartJyvpsServerGroupModel->createServerGroup($param);

        return json($result);
    }

    /**
     * 时间 2023-6-8
     * @title 服务器分组页面
     * @desc 服务器分组页面
     * @url /admin/v1/idcsmart_jyvps/server_group/:id
     * @method  GET
     * @author zn
     * @version v1
     * @param int id - 服务器分组ID required
     * @return object server_group - 服务器分组
     * @return int server_group.id - 服务器分组ID
     * @return string server_group.name - 服务器分组名称
     * @return array servers - 服务器
     * @return int servers[].id - 服务器ID
     * @return string servers[].name - 服务器名称
     * @return string servers[].type - 服务器类型
     * @return int servers[].gid - 服务器分组ID
     * @return array select_servers - 当前分组已选择的服务器ID
     */
    public function index(){
        $param = $this->request->param();

        $IdcsmartJyvpsServerGroupModel = new IdcsmartJyvpsServerGroupModel();

        $result = $IdcsmartJyvpsServerGroupModel->indexServerGroup($param);

        return json($result);
    }

    /**
     * 时间 2023-6-8
     * @title 更新服务器分组
     * @desc 更新服务器分组
     * @url /admin/v1/idcsmart_jyvps/server_group/:id
     * @method  put
     * @author zn
     * @version v1
     * @param string name - 服务器分组名称 required
     * @param string mode - 分配方式(1:平均分配;2:满一个算一个(这两个分配方式写死)) required
     * @param array server_ids - 选择的服务器ID,数组
     */
    public function update(){
        $param = $this->request->param();

        $IdcsmartJyvpsServerGroupValidate = new IdcsmartJyvpsServerGroupValidate();
        if (!$IdcsmartJyvpsServerGroupValidate->scene('update')->check($param)){
            return json(['status'=>400,'msg'=>$IdcsmartJyvpsServerGroupValidate->getError()]);
        }

        $IdcsmartJyvpsServerGroupModel = new IdcsmartJyvpsServerGroupModel();

        $result = $IdcsmartJyvpsServerGroupModel->updateServerGroup($param);

        return json($result);
    }

    /**
     * 时间 2023-6-8
     * @title 删除服务器分组
     * @desc 删除服务器分组
     * @url /admin/v1/idcsmart_jyvps/server_group/:id
     * @method  delete
     * @author zn
     * @version v1
     * @param int id - 服务器分组ID required
     */
    public function delete(){
        $param = $this->request->param();

        $IdcsmartJyvpsServerGroupModel = new IdcsmartJyvpsServerGroupModel();

        $result = $IdcsmartJyvpsServerGroupModel->deleteServerGroup($param);

        return json($result);
    }
    //根据产品获取机房
    public function getVmNodeByProduct()
{
    // 使用 $this->request->param() 获取所有请求参数
    $param = $this->request->param();
    
    // 获取 product_id 参数
    $productId = isset($param['city_id']) ? $param['city_id'] : null;

    // 检查 product_id 是否为空
    if (!$productId) {
        return json([
            'errcode' => 1,
            'errmsg' => '缺少套餐ID'
        ]);
    }

    try {
        // 初始化模型对象
        $IdcsmartJyvpsVmProductModel = new IdcsmartJyvpsVmProductModel();
        $IdcsmartJyvpsVmNodeModel = new IdcsmartJyvpsVmNodeModel();

        // 根据 $productId 去 IdcsmartJyvpsVmProductModel 查询对应的产品数据
        $product = $IdcsmartJyvpsVmProductModel->where('id', $productId)->find();

        // 检查是否找到对应的产品数据
        if (!$product) {
            return json([
                'errcode' => 1,
                'errmsg' => '未找到对应的产品数据'
            ]);
        }

        // 获取产品中的 nodeid 字段，并将其转换为数组
        $nodeIds = explode(',', $product['vmnodeid']);

        // 根据 nodeIds 去 IdcsmartJyvpsVmNodeModel 表中获取机房信息
        $nodes = $IdcsmartJyvpsVmNodeModel->whereIn('id', $nodeIds)->select();

        // 将查询结果转为数组
        $data = $nodes ? $nodes->toArray() : [];

        // 返回成功响应
        return json([
            'errcode' => 0,
            'errmsg' => '获取机房数据成功',
            'data' => $data
        ]);
    } catch (\Exception $e) {
        // 捕获查询异常并返回错误信息
        return json([
            'errcode' => 1,
            'errmsg' => '获取机房数据失败: ' . $e->getMessage()
        ]);
    }
}

    //根据机房获取操作系统
    public function getVmosByNode()
    {
        // 使用 $this->request->param() 获取所有请求参数
        $param = $this->request->param();
                
        // 获取 city_id 参数
        $cityId = isset($param['city_id']) ? $param['city_id'] : null;

        // 检查 city_id 是否为空
        if (!$cityId) {
            return json([
                'errcode' => 1,
                'errmsg' => '缺少机房ID'
            ]);
        }

        try {
           // 初始化模型对象
       
        $IdcsmartJyvpsVmNodeModel = new IdcsmartJyvpsVmNodeModel();
        $IdcsmartJyvpsVmOsModel = new IdcsmartJyvpsVmOsModel();
        // 根据 $productId 去 IdcsmartJyvpsVmProductModel 查询对应的产品数据
        $product = $IdcsmartJyvpsVmNodeModel->where('id', $cityId)->find();

        // 检查是否找到对应的产品数据
        if (!$product) {
            return json([
                'errcode' => 1,
                'errmsg' => '未找到对应的产品数据'
            ]);
        }

        // 获取产品中的 nodeid 字段，并将其转换为数组
        $nodeIds = explode(',', $product['oslist']);

        // 根据 nodeIds 去 IdcsmartJyvpsVmNodeModel 表中获取机房信息  ->where('name', 'not like', '%定制%')
        $nodes = $IdcsmartJyvpsVmOsModel->whereIn('id', $nodeIds)
        ->where('name', 'NOT LIKE', '%定制%')
        ->select();
           
            

        // 将查询结果转为数组
        $data = $nodes ? $nodes->toArray() : [];

            // 返回成功响应
            return json([
                'errcode' => 0,
                'errmsg' => '获取系统数据成功',
                'data' => $data
            ]);
        } catch (\Exception $e) {
            // 捕获查询异常并返回错误信息
            return json([
                'errcode' => 1,
                'errmsg' => '获取系统数据失败: ' . $e->getMessage()
            ]);
        }
    }

    //getVmProductByCity
    public function getVmProductByCity()
{
    // 使用 $this->request->param() 获取所有请求参数
    $param = $this->request->param();
    
    // 获取 city_id 参数
    $cityId = isset($param['city_id']) ? $param['city_id'] : null;

    // 检查 city_id 是否为空
    if (!$cityId) {
        return json([
            'errcode' => 1,
            'errmsg' => '缺少城市ID'
        ]);
    }

    $IdcsmartJyvpsProductConfigoptionSubModel = new IdcsmartJyvpsProductConfigoptionSubModel();
    $vmcity = $IdcsmartJyvpsProductConfigoptionSubModel->where('id', $cityId)->find();
    $cityname = $vmcity['option_name'];

    try {
        // 初始化模型对象
        $IdcsmartJyvpsVmProductModel = new IdcsmartJyvpsVmProductModel();
        $IdcsmartJyvpsCustomCycleModel = new IdcsmartJyvpsCustomCycleModel();
        $IdcsmartJyvpsCustomCyclePricingModel = new IdcsmartJyvpsCustomCyclePricingModel();

        // 查询周期ID，假设周期名称已经固定
        $cycleNames = ['日', '周', '月', '季', '半年', '一年'];
        $cycleIds = $IdcsmartJyvpsCustomCycleModel->whereIn('name', $cycleNames)->column('id', 'name');

        // 从数据库中查询套餐数据
        $vmProducts = $IdcsmartJyvpsVmProductModel->where('city', $vmcity['option_param'])->select();
        $data = $vmProducts ? $vmProducts->toArray() : [];

        // 遍历每个套餐，查询对应的价格
        foreach ($data as &$product) {
            // 判断是否是特价套餐，并提取套餐编号
            // 支持三种套餐类型：特价、标准、高级
            if (strpos($product['name'], '特价') !== false) {
                $optionName = '特价';
            } elseif (strpos($product['name'], '高级') !== false) {
                $optionName = '高级';
            } else {
                $optionName = '标准';
            }

            // 使用正则表达式提取“套餐一”到“套餐五”
            preg_match('/（(.*?)）/', $product['name'], $matches);

            // 输出括号内的内容
            $packageName = isset($matches[1]) ? $matches[1] : '未找到套餐';

            // 根据套餐类型和套餐编号构建option_name
            $fullOptionName = $optionName .$packageName;


            // 查询subId，精确匹配option_name
            $sub = $IdcsmartJyvpsProductConfigoptionSubModel->where('option_name', $fullOptionName)->find();

            // 如果找到了对应的sub，获取subId
            $subId = $sub ? $sub['id'] : null;
            //$subId=11;
            // 如果没有找到对应的subId，跳过此套餐
            if (!$subId) {
                continue;
            }

            // 创建一个空数组来存储每个套餐的价格
            $productPrices = [];

            // 获取价格信息，依次查询不同周期的价格
            foreach ($cycleNames as $cycleName) {
                $cycleId = $cycleIds[$cycleName] ?? null;
                if ($cycleId) {
                    // 查询价格
                    $priceData = $IdcsmartJyvpsCustomCyclePricingModel->where([
                        'custom_cycle_id' => $cycleId,
                        'rel_id' => $subId,
                        'type' => 'configoption'
                    ])->find();

                    // 根据周期名称将价格赋值
                    if ($priceData) {
                        $productPrices[$cycleName] = $priceData['amount'];
                    } else {
                        $productPrices[$cycleName] = null; // 如果没有找到价格，设为 null
                    }
                }
            }

            // 将每个套餐的价格信息添加到产品中
            $product['package_prices'] = $productPrices;
        }

        // 返回成功响应
        return json([
            'errcode' => 0,
            'errmsg' => '获取套餐数据成功',
            'data' => $data
        ]);
    } catch (\Exception $e) {
        // 捕获查询异常并返回错误信息
        return json([
            'errcode' => 1,
            'errmsg' => '获取套餐数据失败: ' . $e->getMessage()
        ]);
    }
}



    public function prience()
    {
        $url = 'http://jianyunip.com/phy/getProvinceList';
        $fields = [
        ];
        // 检查是否获取到记录
        
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url . '?' . http_build_query($fields));  // URL 和参数拼接
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5); // 连接时等待的最大秒数
            curl_setopt($ch, CURLOPT_TIMEOUT, 5); // 最大执行时间
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0)');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));  // 发送 POST 数据

            // 执行 cURL 请求并获取响应
            $response = curl_exec($ch);

            // 检查 cURL 是否发生错误
            if ($response == false) {
                return ['status' => 400, 'msg' => curl_error($ch)];
            }

            // 解析响应 JSON
            $responseData = json_decode($response, true);

            // 如果 JSON 解析失败，返回错误
            if (json_last_error() !== JSON_ERROR_NONE) {
                curl_close($ch);
                return ['status' => 400, 'msg' => 'Invalid JSON response'];
            }

            // 关闭 cURL 会话
            curl_close($ch);

            if (isset($responseData['errcode'])) {
                // 如果 errcode 为 0，返回状态 200 和 msg 'ok'
                if ($responseData['errcode'] == 0) {
                    return $responseData;
                   
                } else {
                    
                }
            } else {
                // 如果没有 errcode 字段，返回错误
                return ['status' => 400, 'msg' => 'Missing errcode in response'];
            }

    }

    //根据产品id获取可用信息
    public function getnodebyprdid()
    {   
        $param = $this->request->param();
        $url = 'http://jianyunip.com/phy/getnodebyprdid';
        $fields = [
            'prdid'=>$param['city_id']
        ];
        // 检查是否获取到记录
        
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url . '?' . http_build_query($fields));  // URL 和参数拼接
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5); // 连接时等待的最大秒数
            curl_setopt($ch, CURLOPT_TIMEOUT, 5); // 最大执行时间
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0)');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));  // 发送 POST 数据

            // 执行 cURL 请求并获取响应
            $response = curl_exec($ch);

            // 检查 cURL 是否发生错误
            if ($response == false) {
                return ['status' => 400, 'msg' => curl_error($ch)];
            }

            // 解析响应 JSON
            $responseData = json_decode($response, true);

            // 如果 JSON 解析失败，返回错误
            if (json_last_error() !== JSON_ERROR_NONE) {
                curl_close($ch);
                return ['status' => 400, 'msg' => 'Invalid JSON response'];
            }

            // 关闭 cURL 会话
            curl_close($ch);

            if (isset($responseData['errcode'])) {
                // 如果 errcode 为 0，返回状态 200 和 msg 'ok'
                if ($responseData['errcode'] == 0) {
                    return $responseData;
                   
                } else {
                    
                }
            } else {
                // 如果没有 errcode 字段，返回错误
                return ['status' => 400, 'msg' => 'Missing errcode in response'];
            }

    }
    function generateUniqueString($length = 8, $prefix = '') {
        // 使用 uniqid() 生成基于当前时间的唯一字符串
        $uniqueString = uniqid($prefix, true);
        
        // 生成一个随机字符串部分，增加随机性
        $randomString = substr(str_shuffle(md5(mt_rand() . microtime())), 0, $length);
        
        // 合并并返回最终的唯一字符串
        return $prefix . $uniqueString . $randomString;
    }

    public function getvminfo()
    {   
        $param = $this->request->param();
        $url = 'http://jianyunip.com/v2/vmInfo';
        $ServerModel = new ServerModel();
        $Serverinfo= $ServerModel ->where([
            'url' => 'http://jianyunip.com',
          
        ])->find();
        // 准备请求参数
        $ti = time();
        $apikey=$Serverinfo['hash'];
        $nonce = $this->generateUniqueString();
        $sign = md5($ti . $nonce . $apikey);
        
        $agentid=$Serverinfo['username'];
        $fields = [
            'vmname'=>$param['vmname'],
        
            'ti' => $ti,
            'agentid' => $agentid,
            'nonce' => $nonce,
            'sign' => $sign,
            'resource' => 'mofang',
        ];
        // 检查是否获取到记录
        
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url . '?' . http_build_query($fields));  // URL 和参数拼接
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5); // 连接时等待的最大秒数
            curl_setopt($ch, CURLOPT_TIMEOUT, 5); // 最大执行时间
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0)');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));  // 发送 POST 数据

            // 执行 cURL 请求并获取响应
            $response = curl_exec($ch);

            // 检查 cURL 是否发生错误
            if ($response == false) {
                return ['status' => 400, 'msg' => curl_error($ch)];
            }

            // 解析响应 JSON
            $responseData = json_decode($response, true);

            // 如果 JSON 解析失败，返回错误
            if (json_last_error() !== JSON_ERROR_NONE) {
                curl_close($ch);
                return ['status' => 400, 'msg' => 'Invalid JSON response'];
            }

            // 关闭 cURL 会话
            curl_close($ch);

            if (isset($responseData['errcode'])) {
                // 如果 errcode 为 0，返回状态 200 和 msg 'ok'
                if ($responseData['errcode'] == 0) {
                    return $responseData;
                   
                } else {
                    return $responseData;
                }
            } else {
                // 如果没有 errcode 字段，返回错误
                return ['status' => 400, 'msg' => 'Missing errcode in response'];
            }

    }
}