<?php
namespace server\idcsmart_jyvps;
use app\common\model\ProductGroupModel;
use app\common\model\ProductModel;
use app\admin\model\PluginModel;
use app\common\model\HostModel;
use app\common\model\SelfDefinedFieldValueModel;
use app\common\model\SelfDefinedFieldModel;
use app\common\model\ServerModel;
use server\idcsmart_jyvps\logic\IdcsmartJyvpsLogic;
use server\idcsmart_jyvps\logic\ProvisionLogic;
use server\idcsmart_jyvps\logic\ToolLogic;
use server\idcsmart_jyvps\model\IdcsmartJyvpsHostConfigoptionModel;
use server\idcsmart_jyvps\model\IdcsmartJyvpsProductConfigoptionModel;
use server\idcsmart_jyvps\model\IdcsmartJyvpsProductConfigoptionSubModel;
use server\idcsmart_jyvps\validate\IdcsmartJyvpsProductValidate;
use server\idcsmart_jyvps\model\IdcsmartJyvpsVmProductModel;
use server\idcsmart_jyvps\model\IdcsmartJyvpsVmOsModel;
use server\idcsmart_jyvps\model\IdcsmartJyvpsVmNodeModel;
use server\idcsmart_jyvps\model\IdcsmartJyvpsProductModel;
use server\idcsmart_jyvps\model\IdcsmartJyvpsPricingModel;
use server\idcsmart_jyvps\model\IdcsmartJyvpsCustomCycleModel;
use server\idcsmart_jyvps\model\IdcsmartJyvpsCustomCyclePricingModel;
use think\facade\Db;

/**
 * 通用产品模块系统方法  ServerModel   IdcsmartJyvpsVmOsModel  IdcsmartJyvpsVmNodeModel  SelfDefinedFieldModel
 */
class IdcsmartJyvps
{

    /**
     * 时间 2024-11-25
     * @title 基础信息
     * @author zn
     * @version v1
     */
    public function metaData()
    {
        return ['display_name'=>'简云vps', 'version'=>'1.0.0'];
    }

    /**
     * 时间 2024-11-25
     * @title 添加表TODO
     * @author zn
     * @version v1
     */
    public function afterCreateFirstServer()
    {
        $sql = [
            "CREATE TABLE `idcsmart_module_idcsmart_jyvps_custom_cycle` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品自定义周期',
  `product_id` int(11) NOT NULL DEFAULT '0' COMMENT '关联商品ID',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '周期名称',
  `cycle_time` int(11) NOT NULL DEFAULT '0' COMMENT '周期时长',
  `cycle_unit` enum('hour','day','month','infinite') NOT NULL DEFAULT 'day' COMMENT '周期单位:hour小时,day天,month月,infinite无限',
  `create_time` int(11) NOT NULL DEFAULT '0',
  `update_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;",
            "CREATE TABLE `idcsmart_module_idcsmart_jyvps_custom_cycle_pricing` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自定义周期价格设置',
  `custom_cycle_id` int(11) NOT NULL DEFAULT '0' COMMENT '自定义周期ID',
  `rel_id` int(11) NOT NULL DEFAULT '0' COMMENT '关联ID:如商品ID,配置项ID',
  `type` enum('product','configoption') NOT NULL DEFAULT 'product' COMMENT '价格类型:product商品,configoption配置项',
  `amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '自定义周期金额:-1表示前台不显示此周期,>=0时表示此周期金额,默认为-1',
  PRIMARY KEY (`id`),
  KEY `type_rel_id` (`rel_id`,`type`),
  KEY `custom_cycle_id` (`custom_cycle_id`),
  KEY `ctr` (`custom_cycle_id`,`rel_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;",
            "CREATE TABLE `idcsmart_module_idcsmart_jyvps_host_configoption` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品关联配置表',
  `host_id` int(11) NOT NULL DEFAULT '0' COMMENT '产品ID',
  `configoption_id` int(11) NOT NULL DEFAULT '0' COMMENT '配置项ID',
  `configoption_sub_id` int(11) NOT NULL DEFAULT '0' COMMENT '子项ID',
  `qty` int(11) NOT NULL DEFAULT '0' COMMENT '配置项为数量类型时的数量',
  `repeat` int(11) NOT NULL DEFAULT '0' COMMENT '重复',
  PRIMARY KEY (`id`),
  KEY `host_id` (`host_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;",
            "CREATE TABLE `idcsmart_module_idcsmart_jyvps_pricing` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('configoption','product') NOT NULL DEFAULT 'product' COMMENT '对应类型:product商品(默认),configoption配置项',
  `rel_id` int(11) NOT NULL DEFAULT '0' COMMENT '关联ID:如商品ID',
  `onetime` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '一次性金额',
  PRIMARY KEY (`id`),
  KEY `type_rel_id` (`type`,`rel_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;",
            "CREATE TABLE `idcsmart_module_idcsmart_jyvps_product` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `order_page_description` text COMMENT '订购页面描述,支持html',
  `allow_qty` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否允许选择数量:1是，0否默认',
  `auto_support` tinyint(1) NOT NULL DEFAULT '0' COMMENT '自动化支持:开启后所有配置选项都可输入参数',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `type` varchar(25) NOT NULL DEFAULT 'server' COMMENT '接口类型：server服务器，server_group服务器组(插件下的服务器和服务器组以及相应的模块)',
  `rel_id` int(11) NOT NULL DEFAULT '0' COMMENT '关联ID:服务器ID,服务器组ID',
   `edition` varchar(50) NOT NULL DEFAULT '' COMMENT '版本professional专业版,free免费版',
  `config_option1` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option2` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option3` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option4` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option5` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option6` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option7` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option8` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option9` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option10` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option11` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option12` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option13` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option14` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option15` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option16` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option17` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option18` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option19` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option20` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option21` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option22` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option23` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  `config_option24` varchar(500) NOT NULL DEFAULT '' COMMENT '自定义配置',
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_id` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;",
            "CREATE TABLE `idcsmart_module_idcsmart_jyvps_product_configoption` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置项表',
  `product_id` int(11) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `option_name` varchar(255) NOT NULL DEFAULT '' COMMENT '配置项名称',
  `option_type` varchar(255) NOT NULL DEFAULT 'select' COMMENT '配置项类型：select下拉单选，multi_select下拉多选，radio点击单选，quantity数量输入，quantity_range数量拖动，yes_no是否，area区域',
  `option_param` varchar(255) NOT NULL DEFAULT '' COMMENT '参数:请求接口',
  `qty_min` int(11) NOT NULL DEFAULT '0' COMMENT '最小值',
  `qty_max` int(11) NOT NULL DEFAULT '0' COMMENT '最大值',
  `order` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `hidden` int(11) NOT NULL DEFAULT '0' COMMENT '是否隐藏:1是，0否',
  `unit` varchar(255) NOT NULL DEFAULT '' COMMENT '单位',
  `allow_repeat` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否允许重复:开启后,前台购买时，可通过点击添加按钮，自动创建一个新的配置项，取名如bw1',
  `max_repeat` int(11) NOT NULL DEFAULT '5' COMMENT '最大允许重复数量',
  `fee_type` varchar(25) NOT NULL DEFAULT 'stage' COMMENT '数量的类型的计费方式：stage阶梯计费，qty数量计费(当前区间价格*数量)',
  `description` text COMMENT '说明',
  `configoption_id` int(11) NOT NULL DEFAULT '0' COMMENT '当前商品其他类型为数量拖动/数量输入的配置项ID',
  `son_product_id` int(11) NOT NULL DEFAULT '0' COMMENT '子商品ID',
  `free` tinyint(1) NOT NULL DEFAULT '0' COMMENT '关联商品首周期是否免费:1是，0否',
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;",
            "CREATE TABLE `idcsmart_module_idcsmart_jyvps_product_configoption_sub` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置子项表',
  `product_configoption_id` int(11) NOT NULL DEFAULT '0' COMMENT '配置项ID',
  `option_name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `option_param` varchar(255) NOT NULL DEFAULT '' COMMENT '参数',
  `qty_min` int(11) NOT NULL DEFAULT '0' COMMENT '最小值',
  `qty_max` int(11) NOT NULL DEFAULT '0' COMMENT '最大值',
  `order` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `hidden` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否隐藏:1是，0否默认',
  `country` varchar(255) NOT NULL DEFAULT '' COMMENT '国家:类型为区域时选择',
  `qty_change` int(11) NOT NULL DEFAULT '0' COMMENT '数量变化最小值',
  PRIMARY KEY (`id`),
  KEY `product_configoption_id` (`product_configoption_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4;",
            "CREATE TABLE `idcsmart_module_idcsmart_jyvps_product_custom_field` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自定义字段表',
  `product_id` int(11) NOT NULL DEFAULT '0' COMMENT '商品ID',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '字段名称',
  `type` varchar(25) NOT NULL DEFAULT 'text' COMMENT '字段类型:text单行文本，areatext多行文本，select下拉单选，multi_select下拉多选，check_box勾选框',
  `description` varchar(2000) NOT NULL DEFAULT '' COMMENT '描述',
  `options` text COMMENT '选项:多选，下拉的',
  `regexpr` text COMMENT '正则匹配，验证规则',
  `require` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否必须:1是，0否默认',
  `admin_only` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否仅管理员可见:1是，0否默认',
  `param` text COMMENT '参数，json格式',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",
            "CREATE TABLE `idcsmart_module_idcsmart_jyvps_product_custom_field_value` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `host_id` int(11) NOT NULL DEFAULT '0' COMMENT '产品ID',
  `field_id` int(11) NOT NULL DEFAULT '0' COMMENT '自定义字段ID',
  `value` text COMMENT '值',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",
            "CREATE TABLE `idcsmart_module_idcsmart_jyvps_server_group` (
  `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '服务器组ID',
  `name` VARCHAR(255) NOT NULL DEFAULT '' COMMENT '组名称',
  `type` VARCHAR(255) NOT NULL DEFAULT '' COMMENT '服务器模块类型',
  `system_type` VARCHAR(255) NOT NULL DEFAULT 'normal' COMMENT '组类型',
  `mode` INT(1) NOT NULL DEFAULT '1' COMMENT '分配方式（1：平均分配  2 满一个算一个）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=INNODB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT;",
            "CREATE TABLE `idcsmart_module_idcsmart_jyvps_server` (
  `id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '服务器配置ID',
  `gid` INT(11) NOT NULL DEFAULT '0' COMMENT '服务器组ID',
  `name` VARCHAR(100) NOT NULL DEFAULT '' COMMENT '名称',
  `ip_address` VARCHAR(100) NOT NULL DEFAULT '' COMMENT 'ip地址',
  `assigned_ips` VARCHAR(100) NOT NULL DEFAULT '' COMMENT '其他IP地址',
  `hostname` VARCHAR(100) NOT NULL DEFAULT '' COMMENT '主机名',
  `monthly_cost` DECIMAL(10,2) NOT NULL DEFAULT '0.00' COMMENT '每月成本',
  `noc` VARCHAR(100) NOT NULL DEFAULT '' COMMENT '数据中心',
  `status_address` VARCHAR(100) NOT NULL DEFAULT '' COMMENT '服务器状态地址',
  `name_server1` VARCHAR(100) NOT NULL DEFAULT '' COMMENT '主域名服务器',
  `name_server1_ip` VARCHAR(100) NOT NULL DEFAULT '',
  `name_server2` VARCHAR(100) NOT NULL DEFAULT '' COMMENT '次域名服务器',
  `name_server2_ip` VARCHAR(100) NOT NULL DEFAULT '',
  `name_server3` VARCHAR(100) NOT NULL DEFAULT '' COMMENT '第三域名服务器',
  `name_server3_ip` VARCHAR(100) NOT NULL DEFAULT '',
  `name_server4` VARCHAR(100) NOT NULL DEFAULT '' COMMENT '第四域名服务器',
  `name_server4_ip` VARCHAR(100) NOT NULL DEFAULT '',
  `name_server5` VARCHAR(100) NOT NULL DEFAULT '' COMMENT '第五域名服务器',
  `name_server5_ip` VARCHAR(100) NOT NULL DEFAULT '',
  `max_accounts` INT(11) NOT NULL DEFAULT '0' COMMENT '最大账号数量（默认为0）',
  `username` VARCHAR(256) NOT NULL DEFAULT '' COMMENT '用户名',
  `password` VARCHAR(256) NOT NULL DEFAULT '' COMMENT '密码',
  `accesshash` VARCHAR(256) NOT NULL DEFAULT '' COMMENT '访问散列值',
  `secure` TINYINT(1) NOT NULL DEFAULT '0' COMMENT '安全，1:选中复选框使用 SSL 连接模式,0不选(默认)',
  `port` varchar(25) NOT NULL DEFAULT '' COMMENT '访问端口',
  `active` TINYINT(1) NOT NULL DEFAULT '0' COMMENT '1.当前模块类型激活的服务器(或默认服务器),0非默认',
  `disabled` TINYINT(1) NOT NULL DEFAULT '0' COMMENT '1勾选禁用，0使用(默认)(单选框)',
  `server_type` VARCHAR(255) NOT NULL DEFAULT 'normal' COMMENT '服务器类型',
  `link_status` TINYINT(3) NOT NULL DEFAULT '1' COMMENT '服务器连接状态 0失败 1成功',
  `type` VARCHAR(100) NOT NULL DEFAULT '' COMMENT '服务器模块类型',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `gid` (`gid`)
) ENGINE=INNODB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=COMPACT;",
            "CREATE TABLE `idcsmart_module_idcsmart_jyvps_server_host_link` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `host_id` int(11) NOT NULL DEFAULT '0',
  `server_id` int(11) NOT NULL DEFAULT '0',
  `dedicatedip` varchar(255) NOT NULL DEFAULT '' COMMENT 'ip',
  `assignedips` varchar(255) NOT NULL DEFAULT '' COMMENT '分配IP',
  `username` varchar(255) NOT NULL DEFAULT '' COMMENT '用户名',
  `password` varchar(255) NOT NULL DEFAULT '' COMMENT '密码',
  `bwlimit` int(11) NOT NULL DEFAULT '0' COMMENT '流量限制',
  `os` varchar(255) NOT NULL DEFAULT '' COMMENT '操作系统',
  `bwusage` decimal(10,2) NOT NULL DEFAULT '0.00',
  `vserverid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `host_id` (`host_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",
"CREATE TABLE `idcsmart_module_idcsmart_jyvps_vmproduct` (
  `id` int(11) UNSIGNED NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '产品名称',
  `cpunum` int(11) NOT NULL DEFAULT '0' COMMENT 'CPU数量',
  `memory` int(11) NOT NULL DEFAULT '0' COMMENT '内存大小 (MB)',
  `dayprice` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '每日价格',
  `weekprice` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '每周价格',
  `monthprice` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '每月价格',
  `threemonthprice` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '季度价格',
  `halfyearprice` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '半年价格',
  `yearprice` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '每年价格',
  `product_configoption_sub_id` int(11) NOT NULL DEFAULT '0' COMMENT '产品配置选项子ID',
  `vmnodeid` varchar(30) NOT NULL,
  `city` int(11) NOT NULL DEFAULT '0' COMMENT '城市id'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",
"CREATE TABLE idcsmart_module_idcsmart_jyvps_vmnode (
    id INT AUTO_INCREMENT PRIMARY KEY,   
    name VARCHAR(255) NOT NULL,          
    oslist VARCHAR(255) NOT NULL                 
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",
"CREATE TABLE idcsmart_module_idcsmart_jyvps_vmos (
    id INT AUTO_INCREMENT PRIMARY KEY,   
    name VARCHAR(255) NOT NULL,          
    type VARCHAR(100) NOT NULL           
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",
"CREATE TABLE `idcsmart_module_idcsmart_jyvps_vmname` (
    `id` INT UNSIGNED AUTO_INCREMENT COMMENT '主键 ID',
    `hostid` INT UNSIGNED NOT NULL COMMENT '主机 ID',
    `osid` INT UNSIGNED NOT NULL COMMENT '操作系统 ID',
    `vmproductid` INT UNSIGNED NOT NULL COMMENT '虚拟机产品 ID',
    `nodeid` INT UNSIGNED NOT NULL COMMENT '节点 ID',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;"

        ];
        foreach($sql as $v){
            Db::execute($v);
        }
    }

    /**
     * 时间 2024-11-25
     * @title 不用之后删除表TODO
     * @author zn
     * @version v1
     */
    public function afterDeleteLastServer()
    {
        $sql = [
            "DROP TABLE IF EXISTS `idcsmart_module_idcsmart_jyvps_custom_cycle`;",
            "DROP TABLE IF EXISTS `idcsmart_module_idcsmart_jyvps_custom_cycle_pricing`;",
            "DROP TABLE IF EXISTS `idcsmart_module_idcsmart_jyvps_host_configoption`;",
            "DROP TABLE IF EXISTS `idcsmart_module_idcsmart_jyvps_pricing`;",
            "DROP TABLE IF EXISTS `idcsmart_module_idcsmart_jyvps_product`;",
            "DROP TABLE IF EXISTS `idcsmart_module_idcsmart_jyvps_product_configoption`;",
            "DROP TABLE IF EXISTS `idcsmart_module_idcsmart_jyvps_product_configoption_sub`;",
            "DROP TABLE IF EXISTS `idcsmart_module_idcsmart_jyvps_product_custom_field`;",
            "DROP TABLE IF EXISTS `idcsmart_module_idcsmart_jyvps_product_custom_field_value`;",
            "DROP TABLE IF EXISTS `idcsmart_module_idcsmart_jyvps_server_group`;",
            "DROP TABLE IF EXISTS `idcsmart_module_idcsmart_jyvps_server`;",
            "DROP TABLE IF EXISTS `idcsmart_module_idcsmart_jyvps_server_host_link`;",
            "DROP TABLE IF EXISTS `idcsmart_module_idcsmart_jyvps_vmproduct`;",
            "DROP TABLE IF EXISTS `idcsmart_module_idcsmart_jyvps_vmnode`;",
            "DROP TABLE IF EXISTS `idcsmart_module_idcsmart_jyvps_vmos`;",
            "DROP TABLE IF EXISTS `idcsmart_module_idcsmart_jyvps_vmname`;",
        ];

        foreach($sql as $v){
            Db::execute($v);
        }
    }
    function generateUniqueString($length = 8, $prefix = '') {
        // 使用 uniqid() 生成基于当前时间的唯一字符串
        $uniqueString = uniqid($prefix, true);
        
        // 生成一个随机字符串部分，增加随机性
        $randomString = substr(str_shuffle(md5(mt_rand() . microtime())), 0, $length);
        
        // 合并并返回最终的唯一字符串
        return $prefix . $uniqueString . $randomString;
    }
    /**
     * 时间 2024-11-25
     * @title 测试连接
     * @author zn
     * @version v1
     */
    public function testConnect($params){
            

        $flag=false;
        //检查是否是第一次安装
        $server_id = $params['server']['id'];

        $ServerModel = new ServerModel();
        $server = $ServerModel->where('id', $server_id)->find();
        $apikey = $server['hash'];
        $agentid = $server['username'];

        // 准备请求参数
        $ti = time();
        $nonce = $this->generateUniqueString();
        $sign = md5($ti . $nonce . $apikey);
        $url = $server['url'] . '/v2/checkflag';
        $fields = [
        
            'ti' => $ti,
            'agentid' => $agentid,
            'nonce' => $nonce,
            'sign' => $sign,
            'resource' => 'mofang',
            'mofangtype'=>'vps',
        ];
        

        // 检查是否获取到记录
        
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url . '?' . http_build_query($fields));  // URL 和参数拼接
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5); // 连接时等待的最大秒数
            curl_setopt($ch, CURLOPT_TIMEOUT, 5); // 最大执行时间
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0)');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));  // 发送 POST 数据

            // 执行 cURL 请求并获取响应
            $response = curl_exec($ch);

            // 检查 cURL 是否发生错误
            if ($response == false) {
                return ['status' => 400, 'msg' => curl_error($ch)];
            }

            // 解析响应 JSON
            $responseData = json_decode($response, true);

            // 如果 JSON 解析失败，返回错误
            if (json_last_error() !== JSON_ERROR_NONE) {
                curl_close($ch);
                return ['status' => 400, 'msg' => 'Invalid JSON response'];
            }

            // 关闭 cURL 会话
            curl_close($ch);

            if (isset($responseData['errcode'])) {
                // 如果 errcode 为 0，返回状态 200 和 msg 'ok'
                if ($responseData['errcode'] == '0') {
                    $flag=true;
                   
                } else {
                    //return ['status' => 400, 'msg' => $responseData['message']];
                }
            } else {
                // 如果没有 errcode 字段，返回错误
                return ['status' => 400, 'msg' => 'Missing errcode in response'];
            }
            //return ['status' => 400, 'msg' => $flag];

           // return ['status' => 200, 'msg' => 'ok'];
        
    


        //执行一次就行
        if($flag){
            //return ['status' => 400, 'msg' => 'cnm'];

            
            // 创建一级分组 "VPS"
            $firstGroup = new ProductGroupModel();
            $firstGroup->name = '简云VPS';
            $firstGroup->hidden = 0; // 假设未隐藏
            $firstGroup->order = 100;  // 排序
            $firstGroup->parent_id = 0; // 一级分组的父级id为0
            $firstGroup->create_time = time(); // 创建时间
            $firstGroup->update_time = time(); // 更新时间
            $firstGroup->save();

            // 获取一级分组的id
            $firstGroupId = $firstGroup->id;

            // 创建二级分组 "电信VPS"
            $secondGroup = new ProductGroupModel();
            $secondGroup->name = 'VPS';
            $secondGroup->hidden = 0; // 假设未隐藏
            $secondGroup->order = 101;  // 排序
            $secondGroup->parent_id = $firstGroupId; // 设置父级id为一级分组的id
            $secondGroup->create_time = time(); // 创建时间
            $secondGroup->update_time = time(); // 更新时间
            $secondGroup->save();
            $secondGroupId = $secondGroup->id;
            //添加商品长效动态
            $rel_id = $params['server']['id'];

            // 创建新的商品实例
            $product = new ProductModel();

            // 设置商品字段
            $product->name = 'VPS';
            $product->product_group_id =$secondGroupId;
            $product->description = '<div style="max-width: 800px; margin: 0 auto; font-family: Arial, sans-serif;">
            <div style="color: #333; font-size: 24px; margin-bottom: 5px; font-weight: bold;">你无法拒绝的理由</div>
            
            <div style="color: #444; font-size: 20px; margin: 5px 0; font-weight: bold;">产品优势 <span style="color: #666; font-size: 16px;">PRODUCT ADVANTAGE</span></div>
            
            <div style="margin: 10px 0;">
                <p style="margin: 8px 0; line-height: 1.4; color: #555;">
                    <strong style="color: #333;">E5 高性能处理器</strong> - 任务处理更高效。
                </p>
                
                <p style="margin: 8px 0; line-height: 1.4; color: #555;">
                    <strong style="color: #333;">ECC 高速内存</strong> - 远程操作更流畅。独立 IP 确保项目稳定
                </p>
                
                <p style="margin: 8px 0; line-height: 1.4; color: #555;">
                    <strong style="color: #333;">快照功能</strong> - 保障数据安全，可随时恢复和备份。
                </p>
            </div>
            </div>
            
                ';
            $product->hidden = 0;
            $product->stock_control = 0;
            $product->qty = 0;
            $product->pay_type = 'recurring_prepayment';
            $product->auto_setup = 1;
            $product->type = 'server';
            $product->rel_id = $rel_id;
            $product->order = 100;
            $product->creating_notice_sms = 0;
            $product->creating_notice_sms_api = 0;
            $product->creating_notice_sms_api_template = 0;
            $product->created_notice_sms = 0;
            $product->created_notice_sms_api = 0;
            $product->created_notice_sms_api_template = 0;
            $product->creating_notice_mail = 0;
            $product->creating_notice_mail_api = 0;
            $product->creating_notice_mail_template = 0;
            $product->created_notice_mail = 0;
            $product->created_notice_mail_api = 0;
            $product->created_notice_mail_template = 0;
            $product->product_id = 0;
            $product->create_time = 1731658860;
            $product->update_time = 1731658922;
            $product->price = 48.00;
            $product->cycle = '月';
            $product->agentable = 0;

            // 保存商品数据
            $product->save();
            $productid=$product->id; //产品id
         // 插入自定义字段数据
         $fields = [
            [
                'type' => 'product',
                'relid' => $productid,
                'field_name' => 'VPS_云服务器名',
                'field_type' => 'text',
                'description' => '输入VPS_云服务器名',
                'regexpr' => '',
                'field_option' => '',
                'order' => 50,
                'is_required' => 0,
                'show_order_page' => 0,
                'show_order_detail' => 1,
                'show_client_host_detail' => 1,
                'show_admin_host_detail' => 1,
                'show_client_host_list' => 1,
                'upstream_id' => 0,
                'create_time' => 1731659257,
                'update_time' => 1731661706,
                'show_admin_host_list' => 1
            ],
            [
                'type' => 'product',
                'relid' => $productid,
                'field_name' => 'VPS_云服务器密码',
                'field_type' => 'text',
                'description' => '密码由8-20个英文字母、数字和特殊符号',
                'regexpr' => '',
                'field_option' => '',
                'order' => 51,
                'is_required' => 0,
                'show_order_page' => 0,
                'show_order_detail' => 1,
                'show_client_host_detail' => 1,
                'show_admin_host_detail' => 1,
                'show_client_host_list' => 1,
                'upstream_id' => 0,
                'create_time' => 1731659277,
                'update_time' => 1731661696,
                'show_admin_host_list' => 1
            ],
            ];

            // 插入字段数据
            $selfDefinedFieldModel = new SelfDefinedFieldModel();
            foreach ($fields as $field) {
                $selfDefinedFieldModel->insert($field);
            }


            // 创建 IdcsmartJyvpsProductModel 实例
                $product = new IdcsmartJyvpsProductModel();

                // 设置插入的数据
                $product->product_id = $productid;
                $product->order_page_description = '';  // 空字符串
                $product->allow_qty = 0;
                $product->auto_support = 0;
                $product->create_time = 1731658923;
                $product->update_time = 0;  // 根据需求设置更新时间
                $product->type = 'server';
                $product->rel_id = 0;
                $product->config_option = '';  // 空字符串

                // 保存数据
                $product->save();

                // 插入第1条数据
                $configOption1 = new IdcsmartJyvpsProductConfigoptionModel();
                $configOption1->product_id = $productid;
                $configOption1->option_name = '区域';
                $configOption1->option_type = 'area';
                $configOption1->option_param = 'city';
                $configOption1->qty_min = 0;
                $configOption1->qty_max = 0;
                $configOption1->order = 1;
                $configOption1->hidden = 0;
                $configOption1->unit = '';
                $configOption1->allow_repeat = 0;
                $configOption1->max_repeat = 0;
                $configOption1->fee_type = '';
                $configOption1->description = '省份';
                $configOption1->configoption_id = 0;
                $configOption1->son_product_id = 0;
                $configOption1->free = 0;
                $configOption1->save();
                $configOptioncityid = $configOption1->id;

                // 插入第2条数据
                $configOption2 = new IdcsmartJyvpsProductConfigoptionModel();
                $configOption2->product_id = $productid;
                $configOption2->option_name = '套餐';
                $configOption2->option_type = 'select';
                $configOption2->option_param = 'vmproduct';
                $configOption2->qty_min = 0;
                $configOption2->qty_max = 0;
                $configOption2->order = 2;
                $configOption2->hidden = 0;
                $configOption2->unit = '';
                $configOption2->allow_repeat = 0;
                $configOption2->max_repeat = 0;
                $configOption2->fee_type = '';
                $configOption2->description = '根据下方描述选择你的套餐';
                $configOption2->configoption_id = 0;
                $configOption2->son_product_id = 0;
                $configOption2->free = 0;
                $configOption2->save();
                $configOptiontype = $configOption2->id;

                // 插入第1条数据
                $configOptionSub1 = new IdcsmartJyvpsProductConfigoptionSubModel();
                $configOptionSub1->product_configoption_id = $configOptiontype;
                $configOptionSub1->option_name = '标准套餐一';
                $configOptionSub1->option_param = 'biaozhun1';
                $configOptionSub1->qty_min = 0;
                $configOptionSub1->qty_max = 0;
                $configOptionSub1->order = 1;
                $configOptionSub1->hidden = 0;
                $configOptionSub1->country = '';
                $configOptionSub1->qty_change = 0;
                
                $configOptionSub1->save();
                $configOptionSub1id=$configOptionSub1->id;
                // 插入第2条数据
                $configOptionSub2 = new IdcsmartJyvpsProductConfigoptionSubModel();
                $configOptionSub2->product_configoption_id = $configOptiontype;
                $configOptionSub2->option_name = '标准套餐二';
                $configOptionSub2->option_param = 'biaozhun2';
                $configOptionSub2->qty_min = 0;
                $configOptionSub2->qty_max = 0;
                $configOptionSub2->order = 2;
                $configOptionSub2->hidden = 0;
                $configOptionSub2->country = '';
                $configOptionSub2->qty_change = 0;                
                $configOptionSub2->save();
                $configOptionSub2id=$configOptionSub2->id;
                // 插入第3条数据
                $configOptionSub3 = new IdcsmartJyvpsProductConfigoptionSubModel();
                $configOptionSub3->product_configoption_id = $configOptiontype;
                $configOptionSub3->option_name = '标准套餐三';
                $configOptionSub3->option_param = 'biaozhun3';
                $configOptionSub3->qty_min = 0;
                $configOptionSub3->qty_max = 0;
                $configOptionSub3->order = 3;
                $configOptionSub3->hidden = 0;
                $configOptionSub3->country = '';
                $configOptionSub3->qty_change = 0;                
                $configOptionSub3->save();
                $configOptionSub3id=$configOptionSub3->id;
                // 插入第4条数据
                $configOptionSub4 = new IdcsmartJyvpsProductConfigoptionSubModel();
                $configOptionSub4->product_configoption_id = $configOptiontype;
                $configOptionSub4->option_name = '标准套餐四';
                $configOptionSub4->option_param = 'biaozhun4';
                $configOptionSub4->qty_min = 0;
                $configOptionSub4->qty_max = 0;
                $configOptionSub4->order = 4;
                $configOptionSub4->hidden = 0;
                $configOptionSub4->country = '';
                $configOptionSub4->qty_change = 0;                
                $configOptionSub4->save();
                $configOptionSub4id=$configOptionSub4->id;
                // 插入第5条数据
                $configOptionSub5 = new IdcsmartJyvpsProductConfigoptionSubModel();
                $configOptionSub5->product_configoption_id = $configOptiontype;
                $configOptionSub5->option_name = '标准套餐五';
                $configOptionSub5->option_param = 'biaozhun5';
                $configOptionSub5->qty_min = 0;
                $configOptionSub5->qty_max = 0;
                $configOptionSub5->order = 5;
                $configOptionSub5->hidden = 0;
                $configOptionSub5->country = '';
                $configOptionSub5->qty_change = 0;                
                $configOptionSub5->save();
                $configOptionSub5id=$configOptionSub5->id;
                // 插入第6条数据
                $configOptionSub6 = new IdcsmartJyvpsProductConfigoptionSubModel();
                $configOptionSub6->product_configoption_id = $configOptiontype;
                $configOptionSub6->option_name = '特价套餐一';
                $configOptionSub6->option_param = 'tejia1';
                $configOptionSub6->qty_min = 0;
                $configOptionSub6->qty_max = 0;
                $configOptionSub6->order = 6;
                $configOptionSub6->hidden = 0;
                $configOptionSub6->country = '';
                $configOptionSub6->qty_change = 0;                
                $configOptionSub6->save();
                $configOptionSub6id=$configOptionSub6->id;
                // 插入第2条数据
                $configOptionSub7 = new IdcsmartJyvpsProductConfigoptionSubModel();
                $configOptionSub7->product_configoption_id = $configOptiontype;
                $configOptionSub7->option_name = '特价套餐二';
                $configOptionSub7->option_param = 'tejia2';
                $configOptionSub7->qty_min = 0;
                $configOptionSub7->qty_max = 0;
                $configOptionSub7->order = 7;
                $configOptionSub7->hidden = 0;
                $configOptionSub7->country = '';
                $configOptionSub7->qty_change = 0;                
                $configOptionSub7->save();
                $configOptionSub7id=$configOptionSub7->id;
                // 插入第2条数据
                $configOptionSub8 = new IdcsmartJyvpsProductConfigoptionSubModel();
                $configOptionSub8->product_configoption_id = $configOptiontype;
                $configOptionSub8->option_name = '特价套餐三';
                $configOptionSub8->option_param = 'tejia3';
                $configOptionSub8->qty_min = 0;
                $configOptionSub8->qty_max = 0;
                $configOptionSub8->order = 8;
                $configOptionSub8->hidden = 0;
                $configOptionSub8->country = '';
                $configOptionSub8->qty_change = 0;                
                $configOptionSub8->save();
                $configOptionSub8id=$configOptionSub8->id;
                // 插入第2条数据
                $configOptionSub9 = new IdcsmartJyvpsProductConfigoptionSubModel();
                $configOptionSub9->product_configoption_id = $configOptiontype;
                $configOptionSub9->option_name = '特价套餐四';
                $configOptionSub9->option_param = 'tejia4';
                $configOptionSub9->qty_min = 0;
                $configOptionSub9->qty_max = 0;
                $configOptionSub9->order = 9;
                $configOptionSub9->hidden = 0;
                $configOptionSub9->country = '';
                $configOptionSub9->qty_change = 0;                
                $configOptionSub9->save();
                $configOptionSub9id=$configOptionSub9->id;
                // 插入第2条数据
                $configOptionSub10 = new IdcsmartJyvpsProductConfigoptionSubModel();
                $configOptionSub10->product_configoption_id = $configOptiontype;
                $configOptionSub10->option_name = '特价套餐五';
                $configOptionSub10->option_param = 'tejia5';
                $configOptionSub10->qty_min = 0;
                $configOptionSub10->qty_max = 0;
                $configOptionSub10->order = 10;
                $configOptionSub10->hidden = 0;
                $configOptionSub10->country = '';
                $configOptionSub10->qty_change = 0;                
                $configOptionSub10->save();
                $configOptionSub10id=$configOptionSub10->id;


                //增加5个高级机房
                $configOptionSub11 = new IdcsmartJyvpsProductConfigoptionSubModel();
                $configOptionSub11->product_configoption_id = $configOptiontype;
                $configOptionSub11->option_name = '高级套餐一';
                $configOptionSub11->option_param = 'gaoji1';
                $configOptionSub11->qty_min = 0;
                $configOptionSub11->qty_max = 0;   
                $configOptionSub11->order = 11;
                $configOptionSub11->hidden = 0;
                $configOptionSub11->country = '';
                $configOptionSub11->qty_change = 0;                
                $configOptionSub11->save();
                $configOptionSub11id=$configOptionSub11->id; 

                $configOptionSub12 = new IdcsmartJyvpsProductConfigoptionSubModel();
                $configOptionSub12->product_configoption_id = $configOptiontype;
                $configOptionSub12->option_name = '高级套餐二';
                $configOptionSub12->option_param = 'gaoji2';
                $configOptionSub12->qty_min = 0;
                $configOptionSub12->qty_max = 0;   
                $configOptionSub12->order = 12;
                $configOptionSub12->hidden = 0;
                $configOptionSub12->country = '';
                $configOptionSub12->qty_change = 0;                
                $configOptionSub12->save();
                $configOptionSub12id=$configOptionSub12->id; 

                $configOptionSub13 = new IdcsmartJyvpsProductConfigoptionSubModel();
                $configOptionSub13->product_configoption_id = $configOptiontype;
                $configOptionSub13->option_name = '高级套餐三';
                $configOptionSub13->option_param = 'gaoji3';
                $configOptionSub13->qty_min = 0;
                $configOptionSub13->qty_max = 0;   
                $configOptionSub13->order = 13;
                $configOptionSub13->hidden = 0;
                $configOptionSub13->country = '';
                $configOptionSub13->qty_change = 0;                
                $configOptionSub13->save();
                $configOptionSub13id=$configOptionSub13->id; 


                $configOptionSub14 = new IdcsmartJyvpsProductConfigoptionSubModel();
                $configOptionSub14->product_configoption_id = $configOptiontype;
                $configOptionSub14->option_name = '高级套餐四';
                $configOptionSub14->option_param = 'gaoji4';
                $configOptionSub14->qty_min = 0;
                $configOptionSub14->qty_max = 0;   
                $configOptionSub14->order = 14;
                $configOptionSub14->hidden = 0;
                $configOptionSub14->country = '';
                $configOptionSub14->qty_change = 0;                
                $configOptionSub14->save();
                $configOptionSub14id=$configOptionSub14->id; 

                $configOptionSub15 = new IdcsmartJyvpsProductConfigoptionSubModel();
                $configOptionSub15->product_configoption_id = $configOptiontype;
                $configOptionSub15->option_name = '高级套餐五';
                $configOptionSub15->option_param = 'gaoji5';
                $configOptionSub15->qty_min = 0;
                $configOptionSub15->qty_max = 0;   
                $configOptionSub15->order = 15;
                $configOptionSub15->hidden = 0;
                $configOptionSub15->country = '';
                $configOptionSub15->qty_change = 0;                
                $configOptionSub15->save();
                $configOptionSub15id=$configOptionSub15->id; 

                // 插入第1条数据
                $pricing = new IdcsmartJyvpsPricingModel();
                $pricing->type = 'product';
                $pricing->rel_id = $productid;
                $pricing->onetime = 0.00;
                $pricing->save();

                // 插入第2条数据
                $pricing = new IdcsmartJyvpsPricingModel();
                $pricing->type = 'configoption';
                $pricing->rel_id = $configOptioncityid;
                $pricing->onetime = 0.00;
                $pricing->save();

                // 插入第3条数据
                $pricing = new IdcsmartJyvpsPricingModel();
                $pricing->type = 'configoption';
                $pricing->rel_id = $configOptiontype;
                $pricing->onetime = 0.00;
                $pricing->save();


                // 插入第1条数据
                $cycle = new IdcsmartJyvpsCustomCycleModel();
                $cycle->product_id = $productid;
                $cycle->name = '日';
                $cycle->cycle_time = 24;
                $cycle->cycle_unit = 'hour';
                $cycle->create_time = 1731658923;
                $cycle->update_time = 1731728029;
                $cycle->save();
                $cycle1 = $cycle->id;
                // 插入第2条数据
                $cycle = new IdcsmartJyvpsCustomCycleModel();
                $cycle->product_id = $productid;
                $cycle->name = '周';
                $cycle->cycle_time = 7;
                $cycle->cycle_unit = 'day';
                $cycle->create_time = 1731658924;
                $cycle->update_time = 0;
                $cycle->save();
                $cycle2 = $cycle->id;
                // 插入第3条数据
                $cycle = new IdcsmartJyvpsCustomCycleModel();
                $cycle->product_id = $productid;
                $cycle->name = '月';
                $cycle->cycle_time = 1;
                $cycle->cycle_unit = 'month';
                $cycle->create_time = 1731658924;
                $cycle->update_time = 0;
                $cycle->save();
                $cycle3 = $cycle->id;
                // 插入第4条数据
                $cycle = new IdcsmartJyvpsCustomCycleModel();
                $cycle->product_id = $productid;
                $cycle->name = '季';
                $cycle->cycle_time = 3;
                $cycle->cycle_unit = 'month';
                $cycle->create_time = 1731658924;
                $cycle->update_time = 0;
                $cycle->save();
                $cycle4 = $cycle->id;
                // 插入第5条数据
                $cycle = new IdcsmartJyvpsCustomCycleModel();
                $cycle->product_id = $productid;
                $cycle->name = '半年';
                $cycle->cycle_time = 6;
                $cycle->cycle_unit = 'month';
                $cycle->create_time = 1731728072;
                $cycle->update_time = 1731728116;
                $cycle->save();
                $cycle5 = $cycle->id;
                $cycle = new IdcsmartJyvpsCustomCycleModel();
                $cycle->product_id = $productid;
                $cycle->name = '一年';
                $cycle->cycle_time = 12;
                $cycle->cycle_unit = 'month';
                $cycle->create_time = 1731728072;
                $cycle->update_time = 1731728116;
                $cycle->save();
                $cycle6 = $cycle->id;
                // 插入第1条数据
                $pricing = new IdcsmartJyvpsCustomCyclePricingModel();
                $pricing->custom_cycle_id = $cycle1;
                $pricing->rel_id = $productid;
                $pricing->type = 'product';
                $pricing->amount = 0.00;
                $pricing->save();
                $pricing = new IdcsmartJyvpsCustomCyclePricingModel();
                $pricing->custom_cycle_id = $cycle2;
                $pricing->rel_id = $productid;
                $pricing->type = 'product';
                $pricing->amount = 0.00;
                $pricing->save();
                $pricing = new IdcsmartJyvpsCustomCyclePricingModel();
                $pricing->custom_cycle_id = $cycle3;
                $pricing->rel_id = $productid;
                $pricing->type = 'product';
                $pricing->amount = 0.00;
                $pricing->save();
                $pricing = new IdcsmartJyvpsCustomCyclePricingModel();
                $pricing->custom_cycle_id = $cycle4;
                $pricing->rel_id = $productid;
                $pricing->type = 'product';
                $pricing->amount = 0.00;
                $pricing->save();
                $pricing = new IdcsmartJyvpsCustomCyclePricingModel();
                $pricing->custom_cycle_id = $cycle5;
                $pricing->rel_id = $productid;
                $pricing->type = 'product';
                $pricing->amount = 0.00;
                $pricing->save();
                $pricing = new IdcsmartJyvpsCustomCyclePricingModel();
                $pricing->custom_cycle_id = $cycle6;
                $pricing->rel_id = $productid;
                $pricing->type = 'product';
                $pricing->amount = 0.00;
                $pricing->save();

                $data = [
                    // 套餐一
                    ['custom_cycle_id' => $cycle1, 'rel_id' => $configOptionSub1id, 'type' => 'configoption', 'amount' => 4],
                    ['custom_cycle_id' => $cycle2, 'rel_id' => $configOptionSub1id, 'type' => 'configoption', 'amount' => 18],
                    ['custom_cycle_id' => $cycle3, 'rel_id' => $configOptionSub1id, 'type' => 'configoption', 'amount' => 68],
                    ['custom_cycle_id' => $cycle4, 'rel_id' => $configOptionSub1id, 'type' => 'configoption', 'amount' => 168],
                    ['custom_cycle_id' => $cycle5, 'rel_id' => $configOptionSub1id, 'type' => 'configoption', 'amount' => 340],
                    ['custom_cycle_id' => $cycle6, 'rel_id' => $configOptionSub1id, 'type' => 'configoption', 'amount' => 680],
                    
                    // 套餐二
                    ['custom_cycle_id' => $cycle1, 'rel_id' => $configOptionSub2id, 'type' => 'configoption', 'amount' => 7],
                    ['custom_cycle_id' => $cycle2, 'rel_id' => $configOptionSub2id, 'type' => 'configoption', 'amount' => 24],
                    ['custom_cycle_id' => $cycle3, 'rel_id' => $configOptionSub2id, 'type' => 'configoption', 'amount' => 72],
                    ['custom_cycle_id' => $cycle4, 'rel_id' => $configOptionSub2id, 'type' => 'configoption', 'amount' => 210],
                    ['custom_cycle_id' => $cycle5, 'rel_id' => $configOptionSub2id, 'type' => 'configoption', 'amount' => 360],
                    ['custom_cycle_id' => $cycle6, 'rel_id' => $configOptionSub2id, 'type' => 'configoption', 'amount' => 720],
                    
                    // 套餐三
                    ['custom_cycle_id' => $cycle1, 'rel_id' => $configOptionSub3id, 'type' => 'configoption', 'amount' => 10],
                    ['custom_cycle_id' => $cycle2, 'rel_id' => $configOptionSub3id, 'type' => 'configoption', 'amount' => 40],
                    ['custom_cycle_id' => $cycle3, 'rel_id' => $configOptionSub3id, 'type' => 'configoption', 'amount' => 120],
                    ['custom_cycle_id' => $cycle4, 'rel_id' => $configOptionSub3id, 'type' => 'configoption', 'amount' => 336],
                    ['custom_cycle_id' => $cycle5, 'rel_id' => $configOptionSub3id, 'type' => 'configoption', 'amount' => 600],
                    ['custom_cycle_id' => $cycle6, 'rel_id' => $configOptionSub3id, 'type' => 'configoption', 'amount' => 1200],
                
                    // 套餐四
                    ['custom_cycle_id' => $cycle1, 'rel_id' => $configOptionSub4id, 'type' => 'configoption', 'amount' => 12],
                    ['custom_cycle_id' => $cycle2, 'rel_id' => $configOptionSub4id, 'type' => 'configoption', 'amount' => 50],
                    ['custom_cycle_id' => $cycle3, 'rel_id' => $configOptionSub4id, 'type' => 'configoption', 'amount' => 150],
                    ['custom_cycle_id' => $cycle4, 'rel_id' => $configOptionSub4id, 'type' => 'configoption', 'amount' => 420],
                    ['custom_cycle_id' => $cycle5, 'rel_id' => $configOptionSub4id, 'type' => 'configoption', 'amount' => 750],
                    ['custom_cycle_id' => $cycle6, 'rel_id' => $configOptionSub4id, 'type' => 'configoption', 'amount' => 1500],
                
                    // 套餐五
                    ['custom_cycle_id' => $cycle1, 'rel_id' => $configOptionSub5id, 'type' => 'configoption', 'amount' => 24],
                    ['custom_cycle_id' => $cycle2, 'rel_id' => $configOptionSub5id, 'type' => 'configoption', 'amount' => 100],
                    ['custom_cycle_id' => $cycle3, 'rel_id' => $configOptionSub5id, 'type' => 'configoption', 'amount' => 300],
                    ['custom_cycle_id' => $cycle4, 'rel_id' => $configOptionSub5id, 'type' => 'configoption', 'amount' => 840],
                    ['custom_cycle_id' => $cycle5, 'rel_id' => $configOptionSub5id, 'type' => 'configoption', 'amount' => 1500],
                    ['custom_cycle_id' => $cycle6, 'rel_id' => $configOptionSub5id, 'type' => 'configoption', 'amount' => 3000],

                    ['custom_cycle_id' => $cycle1, 'rel_id' => $configOptionSub6id, 'type' => 'configoption', 'amount' => 3],
                    ['custom_cycle_id' => $cycle2, 'rel_id' => $configOptionSub6id, 'type' => 'configoption', 'amount' => 16],
                    ['custom_cycle_id' => $cycle3, 'rel_id' => $configOptionSub6id, 'type' => 'configoption', 'amount' => 48],
                    ['custom_cycle_id' => $cycle4, 'rel_id' => $configOptionSub6id, 'type' => 'configoption', 'amount' => 130],
                    ['custom_cycle_id' => $cycle5, 'rel_id' => $configOptionSub6id, 'type' => 'configoption', 'amount' => 240],
                    ['custom_cycle_id' => $cycle6, 'rel_id' => $configOptionSub6id, 'type' => 'configoption', 'amount' => 480],
                    
                    // 套餐二
                    ['custom_cycle_id' => $cycle1, 'rel_id' => $configOptionSub7id, 'type' => 'configoption', 'amount' => 7],
                    ['custom_cycle_id' => $cycle2, 'rel_id' => $configOptionSub7id, 'type' => 'configoption', 'amount' => 24],
                    ['custom_cycle_id' => $cycle3, 'rel_id' => $configOptionSub7id, 'type' => 'configoption', 'amount' => 72],
                    ['custom_cycle_id' => $cycle4, 'rel_id' => $configOptionSub7id, 'type' => 'configoption', 'amount' => 210],
                    ['custom_cycle_id' => $cycle5, 'rel_id' => $configOptionSub7id, 'type' => 'configoption', 'amount' => 360],
                    ['custom_cycle_id' => $cycle6, 'rel_id' => $configOptionSub7id, 'type' => 'configoption', 'amount' => 720],
                    
                    // 套餐三
                    ['custom_cycle_id' => $cycle1, 'rel_id' => $configOptionSub8id, 'type' => 'configoption', 'amount' => 10],
                    ['custom_cycle_id' => $cycle2, 'rel_id' => $configOptionSub8id, 'type' => 'configoption', 'amount' => 40],
                    ['custom_cycle_id' => $cycle3, 'rel_id' => $configOptionSub8id, 'type' => 'configoption', 'amount' => 120],
                    ['custom_cycle_id' => $cycle4, 'rel_id' => $configOptionSub8id, 'type' => 'configoption', 'amount' => 336],
                    ['custom_cycle_id' => $cycle5, 'rel_id' => $configOptionSub8id, 'type' => 'configoption', 'amount' => 600],
                    ['custom_cycle_id' => $cycle6, 'rel_id' => $configOptionSub8id, 'type' => 'configoption', 'amount' => 1200],
                
                    // 套餐四
                    ['custom_cycle_id' => $cycle1, 'rel_id' => $configOptionSub9id, 'type' => 'configoption', 'amount' => 12],
                    ['custom_cycle_id' => $cycle2, 'rel_id' => $configOptionSub9id, 'type' => 'configoption', 'amount' => 50],
                    ['custom_cycle_id' => $cycle3, 'rel_id' => $configOptionSub9id, 'type' => 'configoption', 'amount' => 150],
                    ['custom_cycle_id' => $cycle4, 'rel_id' => $configOptionSub9id, 'type' => 'configoption', 'amount' => 420],
                    ['custom_cycle_id' => $cycle5, 'rel_id' => $configOptionSub9id, 'type' => 'configoption', 'amount' => 750],
                    ['custom_cycle_id' => $cycle6, 'rel_id' => $configOptionSub9id, 'type' => 'configoption', 'amount' => 1500],
                
                    // 套餐五
                    ['custom_cycle_id' => $cycle1, 'rel_id' => $configOptionSub10id, 'type' => 'configoption', 'amount' => 24],
                    ['custom_cycle_id' => $cycle2, 'rel_id' => $configOptionSub10id, 'type' => 'configoption', 'amount' => 100],
                    ['custom_cycle_id' => $cycle3, 'rel_id' => $configOptionSub10id, 'type' => 'configoption', 'amount' => 300],
                    ['custom_cycle_id' => $cycle4, 'rel_id' => $configOptionSub10id, 'type' => 'configoption', 'amount' => 840],
                    ['custom_cycle_id' => $cycle5, 'rel_id' => $configOptionSub10id, 'type' => 'configoption', 'amount' => 1500],
                    ['custom_cycle_id' => $cycle6, 'rel_id' => $configOptionSub10id, 'type' => 'configoption', 'amount' => 3000],



                    // 套餐一
                    ['custom_cycle_id' => $cycle1, 'rel_id' => $configOptionSub11id, 'type' => 'configoption', 'amount' => 5],
                    ['custom_cycle_id' => $cycle2, 'rel_id' => $configOptionSub11id, 'type' => 'configoption', 'amount' => 22],
                    ['custom_cycle_id' => $cycle3, 'rel_id' => $configOptionSub11id, 'type' => 'configoption', 'amount' => 80],
                    ['custom_cycle_id' => $cycle4, 'rel_id' => $configOptionSub11id, 'type' => 'configoption', 'amount' => 240],
                    ['custom_cycle_id' => $cycle5, 'rel_id' => $configOptionSub11id, 'type' => 'configoption', 'amount' => 480],
                    ['custom_cycle_id' => $cycle6, 'rel_id' => $configOptionSub11id, 'type' => 'configoption', 'amount' => 800],

                    // 套餐二
                    ['custom_cycle_id' => $cycle1, 'rel_id' => $configOptionSub12id, 'type' => 'configoption', 'amount' => 10],
                    ['custom_cycle_id' => $cycle2, 'rel_id' => $configOptionSub12id, 'type' => 'configoption', 'amount' => 40],
                    ['custom_cycle_id' => $cycle3, 'rel_id' => $configOptionSub12id, 'type' => 'configoption', 'amount' => 120],
                    ['custom_cycle_id' => $cycle4, 'rel_id' => $configOptionSub12id, 'type' => 'configoption', 'amount' => 360],
                    ['custom_cycle_id' => $cycle5, 'rel_id' => $configOptionSub12id, 'type' => 'configoption', 'amount' => 720],
                    ['custom_cycle_id' => $cycle6, 'rel_id' => $configOptionSub12id, 'type' => 'configoption', 'amount' => 1200],

                    // 套餐三
                    ['custom_cycle_id' => $cycle1, 'rel_id' => $configOptionSub13id, 'type' => 'configoption', 'amount' => 15],
                    ['custom_cycle_id' => $cycle2, 'rel_id' => $configOptionSub13id, 'type' => 'configoption', 'amount' => 48],
                    ['custom_cycle_id' => $cycle3, 'rel_id' => $configOptionSub13id, 'type' => 'configoption', 'amount' => 160],
                    ['custom_cycle_id' => $cycle4, 'rel_id' => $configOptionSub13id, 'type' => 'configoption', 'amount' => 480],
                    ['custom_cycle_id' => $cycle5, 'rel_id' => $configOptionSub13id, 'type' => 'configoption', 'amount' => 960],
                    ['custom_cycle_id' => $cycle6, 'rel_id' => $configOptionSub13id, 'type' => 'configoption', 'amount' => 1600],

                    // 套餐四
                    ['custom_cycle_id' => $cycle1, 'rel_id' => $configOptionSub14id, 'type' => 'configoption', 'amount' => 18],
                    ['custom_cycle_id' => $cycle2, 'rel_id' => $configOptionSub14id, 'type' => 'configoption', 'amount' => 60],
                    ['custom_cycle_id' => $cycle3, 'rel_id' => $configOptionSub14id, 'type' => 'configoption', 'amount' => 200],
                    ['custom_cycle_id' => $cycle4, 'rel_id' => $configOptionSub14id, 'type' => 'configoption', 'amount' => 600],
                    ['custom_cycle_id' => $cycle5, 'rel_id' => $configOptionSub14id, 'type' => 'configoption', 'amount' => 1200],
                    ['custom_cycle_id' => $cycle6, 'rel_id' => $configOptionSub14id, 'type' => 'configoption', 'amount' => 2000],

                    // 套餐五
                    ['custom_cycle_id' => $cycle1, 'rel_id' => $configOptionSub15id, 'type' => 'configoption', 'amount' => 22],
                    ['custom_cycle_id' => $cycle2, 'rel_id' => $configOptionSub15id, 'type' => 'configoption', 'amount' => 88],
                    ['custom_cycle_id' => $cycle3, 'rel_id' => $configOptionSub15id, 'type' => 'configoption', 'amount' => 240],
                    ['custom_cycle_id' => $cycle4, 'rel_id' => $configOptionSub15id, 'type' => 'configoption', 'amount' => 720],
                    ['custom_cycle_id' => $cycle5, 'rel_id' => $configOptionSub15id, 'type' => 'configoption', 'amount' => 1440],
                    ['custom_cycle_id' => $cycle6, 'rel_id' => $configOptionSub15id, 'type' => 'configoption', 'amount' => 2400],
                ];
                
                // 批量插入数据
                $pricing = new IdcsmartJyvpsCustomCyclePricingModel();
                $pricing->insertAll($data);
                

                
        }

               // return ['status' => 200, 'msg' => 'ok'];

                

                

                //添加更新产品
        $IdcsmartJyvpsProductConfigoptionModel = new IdcsmartJyvpsProductConfigoptionModel();

        // 查询所有符合条件的配置项
        $productOption = $IdcsmartJyvpsProductConfigoptionModel->where('option_param', 'city')->find();
        $server_id = $params['server']['id'];
        
        $ServerModel = new ServerModel();
        $server = $ServerModel->where('id', $server_id)->find();
        $apikey = $server['hash'];
        $agentid = $server['username'];
        //return ['status' => 200, 'msg' => 'ok'];
        // 准备请求参数
        $ti = time();
        $nonce = $this->generateUniqueString();
        $sign = md5($ti . $nonce . $apikey);
        $url = $server['url'] . '/phy/vmprdcityids';
        $fields = [
        
            'ti' => $ti,
            'agentid' => $agentid,
            'nonce' => $nonce,
            'sign' => $sign,
            'resource' => 'mofang',
        ];
            
        // 检查是否获取到记录
        if ($productOption) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url . '?' . http_build_query($fields));  // URL 和参数拼接
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5); // 连接时等待的最大秒数
            curl_setopt($ch, CURLOPT_TIMEOUT, 5); // 最大执行时间
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0)');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));  // 发送 POST 数据

            // 执行 cURL 请求并获取响应
            $response = curl_exec($ch);

            // 检查 cURL 是否发生错误
            if ($response == false) {
                return ['status' => 400, 'msg' => curl_error($ch)];
            }

            // 解析响应 JSON
            $responseData = json_decode($response, true);

            // 如果 JSON 解析失败，返回错误
            if (json_last_error() !== JSON_ERROR_NONE) {
                curl_close($ch);
                return ['status' => 400, 'msg' => 'Invalid JSON response'];
            }

            // 关闭 cURL 会话
            curl_close($ch);

            if (isset($responseData['errcode'])) {
                // 如果 errcode 为 0，返回状态 200 和 msg 'ok'
                if ($responseData['errcode'] == 0) {
                    // 获取城市列表
                   // return ['status' => 200, 'msg' => 'ok'];
                    $cities = $responseData['msg']['city'];
                    $prdlist=$responseData['msg']['prdlist'];
                    $nodelist=$responseData['msg']['nodelist'];
                    $oslist=$responseData['msg']['oslist'];
                   
                    $IdcsmartJyvpsVmProductModel= new IdcsmartJyvpsVmProductModel();
                    $IdcsmartJyvpsVmOsModel=new IdcsmartJyvpsVmOsModel();
                    $IdcsmartJyvpsVmNodeModel=new IdcsmartJyvpsVmNodeModel();
                     // 插入或更新产品数据
                    foreach ($prdlist as $product) {
                        $productData = [
                            'id' => $product['id'],
                            'name' => $product['name'],
                            'vmnodeid' => $product['vmnodes'],
                            'cpunum' => $product['cpuNum'],
                            'memory' => $product['memMax'],
                            'city' => $product['city'],
                            'product_configoption_sub_id'=>$productOption['id']
                        ];
                        
                        // 判断数据是否存在
                        $existingProduct = $IdcsmartJyvpsVmProductModel->find($product['id']);
                        if ($existingProduct) {
                            // 更新数据
                            //return ['status' => 200, 'msg' => 'ok'];
                            $IdcsmartJyvpsVmProductModel->update($productData, ['id' => $product['id']]);
                           
                        } else {
                            // 插入数据
                            $IdcsmartJyvpsVmProductModel->insert($productData);
                        }
                    }
                    //return ['status' => 200, 'msg' => 'ok'];
                    
                    // 插入或更新节点数据
                    foreach ($nodelist as $node) {
                        if ($node['id']==0){
                            break;
                        }
                        $nodeData = [
                            'id' => $node['id'],
                            'name' => $node['name'],
                            'oslist' => $node['oslist']
                        ];
                        
                        // 判断数据是否存在
                        $existingNode = $IdcsmartJyvpsVmNodeModel->find($node['id']);
                        if ($existingNode) {
                            // 更新数据
                            $IdcsmartJyvpsVmNodeModel->update($nodeData, ['id' => $node['id']]);
                        } else {
                            // 插入数据
                            $IdcsmartJyvpsVmNodeModel->insert($nodeData);
                        }
                    }
                    
                    // 插入或更新操作系统数据
                    foreach ($oslist as $os) {
                        $osData = [
                            'id' => $os['id'],
                            'name' => $os['osname'],
                            'type' => $os['ostype']
                        ];
                        
                        // 判断数据是否存在
                        $existingOS = $IdcsmartJyvpsVmOsModel->find($os['id']);
                        if ($existingOS) {
                            // 更新数据
                            $IdcsmartJyvpsVmOsModel->update($osData, ['id' => $os['id']]);
                        } else {
                            // 插入数据
                            $IdcsmartJyvpsVmOsModel->insert($osData);
                        }
                    }
                    //return ['status' => 200, 'msg' => 'ok'];

                    // 遍历所有查询到的 productOptions
                    // foreach ($productOptions as $productOption) {

                        $ProductConfigoptionId = $productOption['id'];
                        // 创建一个 IdcsmartJyvpsProductConfigoptionSubModel 实例
                         $IdcsmartJyvpsProductConfigoptionSubModel = new IdcsmartJyvpsProductConfigoptionSubModel();
                        // $IdcsmartJyvpsProductConfigoptionSubModel
                        // ->where('product_configoption_id', $ProductConfigoptionId)
                        // ->delete();
                        // 遍历每个城市数据，插入或更新到数据库中
                        foreach ($cities as $cityData) {
                            // 使用正则表达式提取固定部分
                                $cityname=$cityData['cityname'];

                                // 检查是否已存在该 option_name 的固定部分
                                $existingRecord = $IdcsmartJyvpsProductConfigoptionSubModel
                                                    ->where('product_configoption_id', $ProductConfigoptionId)
                                                    ->where('option_name',$cityname)
                                                    ->find();

                                // 准备数据
                                $data = [
                                    'product_configoption_id' => $ProductConfigoptionId,
                                    'option_name'             => $cityname, // 完整的城市信息，如 '南通s501(可用157个)'
                                    'option_param'            => $cityData['city'], // 城市 ID
                                    'qty_min'                 => 0,
                                    'qty_max'                 => 0,
                                    'hidden'                  => 0,
                                    'country'                 => $cityData['jianchen'],
                                    'qty_change'              => 0,
                                ];

                                if ($existingRecord) {
                                    // 如果记录存在，执行更新操作
                                    $IdcsmartJyvpsProductConfigoptionSubModel->where('id', $existingRecord['id'])->update($data);
                                } else {
                                    // 如果记录不存在，执行插入操作
                                    
                                    $IdcsmartJyvpsProductConfigoptionSubModel->insert($data);
                               }
                            }
                        
                    // }
                } else {
                    // 如果 errcode 为 1，返回状态 400 和 msg 为服务器返回的 msg 字段
                    $msg = isset($responseData['msg']) ? $responseData['msg'] : 'Unknown error';
                    return ['status' => 400, 'msg' => '未知'];
                }
            } else {
                // 如果没有 errcode 字段，返回错误
                return ['status' => 400, 'msg' => 'Missing errcode in response'];
            }
        } else {
            // 如果没有获取到记录
            return ['status' => 400, 'msg' => 'No matching product options found'];
        }

        //return ['status' => 200, 'msg' => 'ok'];
        $username = isset($params['server']['username']) ? $params['server']['username'] : '';
        $password = isset($params['server']['hash']) ? $params['server']['hash'] : '';

        // 目标 URL
        $url = $params['server']['url'] . '/phy/mofangcheck';

        // 准备发送的数据md5($password . "jy.com")
        $fields = [
            'username' => $username,
            'password' => md5($password . "jy.com"),
        ];
        $param=null;
        //return ['status' => 400, 'msg' =>http_build_query($fields)];
        // 设置 cURL 参数
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url . '?' . http_build_query($fields)."&osid=".$param['configoptions']['osid']);  // URL 和参数拼接
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5); // 连接时等待的最大秒数
        curl_setopt($ch, CURLOPT_TIMEOUT, 5); // 最大执行时间
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0)');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields)."&osid=".$param['configoptions']['osid']);  // 发送 POST 数据

        // 执行 cURL 请求并获取响应
        $response = curl_exec($ch);
        //return ['status' => 400, 'msg' =>'未知'];
        // 检查 cURL 是否发生错误
        if ($response == false) {
            return ['status' => 400, 'msg' => curl_error($ch)];
        }
        

        // 解析响应 JSON
        $responseData = json_decode($response, true);

        // 如果 JSON 解析失败，返回错误
        if (json_last_error() !== JSON_ERROR_NONE) {
            curl_close($ch);
            return ['status' => 400, 'msg' => 'Invalid JSON response'];
        }

        // 关闭 cURL 会话
        curl_close($ch);

        // 检查返回数据中的 errcode
        if (isset($responseData['errcode'])) {
            // 如果 errcode 为 0，返回状态 200 和 msg 'ok'
            if ($responseData['errcode'] == 0) {
                return ['status' => 200, 'msg' => 'ok'];
            } else {
                // 如果 errcode 为 1，返回状态 400 和 msg 为服务器返回的 msg 字段
                $msg = isset($responseData['msg']) ? $responseData['msg'] : 'Unknown error';
                return ['status' => 400, 'msg' => $msg];
            }
        } else {
            // 如果没有 errcode 字段，返回错误
            return ['status' => 400, 'msg' => 'Missing errcode in response'];
        }
    }

    /**
     * 时间 2024-11-25
     * @title 模块开通
     * @author zn
     * @version v1
     */
    public function createAccount($params){
        # 配置中关联子模块,调子模块中开通,使用以前的逻辑
        $ProvisionLogic = new ProvisionLogic();
        $res = $ProvisionLogic->createAccount($params['host']['id']);
        return $res;
    }

    /**
     * 时间 2024-11-25
     * @title 模块暂停
     * @author zn
     * @version v1
     */
    public function suspendAccount($params){
        # 配置中关联子模块,调子模块中开通,使用以前的逻辑
        $ProvisionLogic = new ProvisionLogic();
        $res = $ProvisionLogic->suspendAccount($params['host']['id']);
        return $res;
    }

    /**
     * 时间 2024-11-25
     * @title 模块解除暂停
     * @author zn
     * @version v1
     */
    public function unsuspendAccount($params){
        # 配置中关联子模块,调子模块中开通,使用以前的逻辑
        $ProvisionLogic = new ProvisionLogic();
        $res = $ProvisionLogic->unsuspendAccount($params['host']['id']);
        return $res;
    }

    /**
     * 时间 2024-11-25
     * @title 模块删除
     * @author zn
     * @version v1
     */
    public function terminateAccount($params){
        # 配置中关联子模块,调子模块中开通,使用以前的逻辑
        $ProvisionLogic = new ProvisionLogic();
        $res = $ProvisionLogic->terminateAccount($params['host']['id']);
        return $res;
    }

    /**
     * 时间 2024-11-25
     * @title 续费后调用
     * @author zn
     * @version v1
     */
    public function renew($params){
        # 配置中关联子模块,调子模块中开通,使用以前的逻辑
        $ProvisionLogic = new ProvisionLogic();
        $res = $ProvisionLogic->renew($params['host']['id']);
        return $res;
    }

    /**
     * 时间 2024-11-25
     * @title 升降级后调用
     * @author zn
     * @version v1
     */
    public function changePackage($params){
        
        // 升降级成功修改授权数量
        $IdcsmartJyvpsHostConfigoptionModel = new IdcsmartJyvpsHostConfigoptionModel();
        $IdcsmartJyvpsProductConfigoptionModel = new IdcsmartJyvpsProductConfigoptionModel();
        $IdcsmartJyvpsProductConfigoptionSubModel = new IdcsmartJyvpsProductConfigoptionSubModel();
        $IdcsmartJyvpsLogic = new IdcsmartJyvpsLogic();
        $data = $params['custom']['configoption']??[];
        try{
            # 获取旧配置
            $packageData = [];
            $oldConfigoptions = $IdcsmartJyvpsHostConfigoptionModel->where('host_id',$params['host']['id'])->select()->toArray();
            foreach ($oldConfigoptions as $oldConfigoption){
                $configoption = $IdcsmartJyvpsProductConfigoptionModel->field('option_type,option_name,option_param')->where('id',$oldConfigoption['configoption_id'])->find();
                $sub = $IdcsmartJyvpsProductConfigoptionSubModel->field('option_name,option_param')->where('id',$oldConfigoption['configoption_sub_id'])->find();
                if (!empty($configoption)){
                    if ($IdcsmartJyvpsLogic->checkQuantity($configoption['option_type'])){
                        $packageData['configoptions'][$configoption['option_param']] = $oldConfigoption['qty'];
                    }else{
                        $packageData['configoptions'][$configoption['option_param']] = $sub['option_param']??"";
                    }
                }
            }

            foreach ($data as $key=>$value){
                $optionType = $IdcsmartJyvpsProductConfigoptionModel->where('id',$key)->value('option_type');
                if ($IdcsmartJyvpsLogic->checkQuantity($optionType)){
                    // 删除旧的
                    $IdcsmartJyvpsHostConfigoptionModel->where('host_id',$params['host']['id'])
                        ->where('configoption_id',$key)
                        ->delete();
                    // 插入新的数据
                    foreach ($value as $k=>$item){
                        $IdcsmartJyvpsHostConfigoptionModel->insert([
                            'host_id' => $params['host']['id'],
                            'configoption_id' => $key,
                            'configoption_sub_id' => 0,
                            'qty' => $item,
                            'repeat' => $k
                        ]);
                    }
                }elseif ($IdcsmartJyvpsLogic->checkMultiSelect($optionType)){
                    // 删除旧的
                    $IdcsmartJyvpsHostConfigoptionModel->where('host_id',$params['host']['id'])
                        ->where('configoption_id',$key)
                        ->delete();
                    // 插入新的数据
                    foreach ($value as $item){
                        $IdcsmartJyvpsHostConfigoptionModel->insert([
                            'host_id' => $params['host']['id'],
                            'configoption_id' => $key,
                            'configoption_sub_id' => $item,
                            'qty' => 0,
                            'repeat' => 0
                        ]);
                    }
                }else{
                    $IdcsmartJyvpsHostConfigoptionModel->where('host_id',$params['host']['id'])
                        ->where('configoption_id',$key)
                        ->update([
                            'configoption_sub_id' => $value
                        ]);
                }
            }
        }catch (\Exception $e){
            file_put_contents(IDCSMART_ROOT.'/upgrade.txt', $e->getMessage());
        }

        # 配置中关联子模块,调子模块中开通,使用以前的逻辑
        $ProvisionLogic = new ProvisionLogic();
        $result =  $ProvisionLogic->changePackage($params['host']['id'],$packageData);

        // $result['status'] = 200;
        // $result['msg'] = '升降级成功';

        return $result;
    }

    /**
     * 时间 2024-11-25
     * @title 变更商品后调用
     * @author zn
     * @version v1
     */
    public function changeProduct($params)
    {
        $params['host_id'] = $params['host']['id'];

        $this->afterSettle($params);
    }

    /**
     * 时间 2022-09-27
     * @title 价格计算
     * @author zn
     * @version v1
     * @param   ProductModel params.product - 商品模型
     * @param   array params.custom - 自定义参数
     * @param   int params.custom.data_center_id - 数据中心ID require
     * @param   int params.custom.package_id - 套餐ID require
     * @param   int params.custom.image_id - 镜像ID
     * @param   string params.custom.hostname - 主机名
     * @param   string params.custom.password - 密码
     * @param   int params.custom.backup_enable 0 是否启用备份(0=不启用,1=启用)
     * @param   int params.custom.panel_enable 0 是否启用面板密码(0=不启用,1=启用)
     * @param   int params.custom.duration_price_id - 周期价格ID require
     * @return  [type]         [description]
     */
    public function cartCalculatePrice($params)
    {
        $IdcsmartJyvpsProductValidate = new IdcsmartJyvpsProductValidate();

        $params['custom']['product_id'] = $params['product']['id'];

        $params['custom']['qty'] = $params['qty'];

        if(!$IdcsmartJyvpsProductValidate->scene('cart_calculate')->check($params['custom'])){
            return ['status'=>400 , 'msg'=>lang_plugins($IdcsmartJyvpsProductValidate->getError())];
        }

        $IdcsmartJyvpsLogic = new IdcsmartJyvpsLogic();

        $res = $IdcsmartJyvpsLogic->cartCalculatePrice($params['custom']);

        return $res;
    }

    /**
     * 时间 2024-11-25
     * @title 切换商品后的输出
     * @author zn
     * @version v1
     */
    public function serverConfigOption()
    {
        $res = [
            'template'=>'template/admin/common_config.html',
        ];

        return $res;
    }

    /**
     * 时间 2022-09-27
     * @title 前台产品内页输出,TODO
     * @author zn
     * @version v1
     */
    public function clientArea($params)
    {
        if (use_mobile()){ // 手机端
            $mobileTheme = configuration('clientarea_theme_mobile');
            $type = 'mobile';
            // 1、配置主题没有走默认的
            if (!file_exists(__DIR__."/template/clientarea/mobile/{$mobileTheme}/product_detail.html")){
                $mobileTheme = "default";
            }
            $res = [
                'template' => "template/clientarea/{$type}/{$mobileTheme}/product_detail.html"
            ];
        }else{ // pc端
            $clientareaTheme = configuration('clientarea_theme');
            if (!file_exists(__DIR__."/template/clientarea/pc/{$clientareaTheme}/product_detail.html")){
                $clientareaTheme = "default";
            }
            $res = [
                'template' => "template/clientarea/pc/{$clientareaTheme}/product_detail.html"
            ];
        }

        return $res;
    }

    /**
     * 时间 2022-10-13
     * @title 产品列表
     * @author hh
     * @version v1
     * @param   [type] $params [description]
     * @return  [type]         [description]
     */
    public function hostList($params){
        if (use_mobile()){ // 手机端
            $mobileTheme = configuration('clientarea_theme_mobile');
            $type = 'mobile';
            // 1、配置主题没有走默认的
            if (!file_exists(__DIR__."/template/clientarea/mobile/{$mobileTheme}/product_list.html")){
                $mobileTheme = "default";
            }
            $res = [
                'template' => "template/clientarea/{$type}/{$mobileTheme}/product_list.html"
            ];
        }else{ // pc端
            $clientareaTheme = configuration('clientarea_theme');
            if (!file_exists(__DIR__."/template/clientarea/pc/{$clientareaTheme}/product_list.html")){
                $clientareaTheme = "default";
            }
            $res = [
                'template' => "template/clientarea/pc/{$clientareaTheme}/product_list.html"
            ];
        }

        return $res;
    }

    /**
     * 时间 2022-10-13
     * @title 前台购买
     * @author hh
     * @version v1
     * @param   string x       -             x
     * @param   [type] $params [description]
     * @return  [type]         [description]
     */
    public function clientProductConfigOption($params){
        $PluginModel = new PluginModel();
        $addons = $PluginModel->plugins('addon');
        if (use_mobile()){ // 手机端
            $mobileTheme = configuration('cart_theme_mobile');
            // 1、配置主题没有走默认的
            if (!file_exists(__DIR__."/template/cart/mobile/{$mobileTheme}/goods.html")){
                $mobileTheme = "default";
            }
            $res = [
                'vars' => [
                    'template_catalog' => 'clientarea',
                    'themes' => 'mobile/'.configuration('clientarea_theme'),
                    'addons' => $addons['list']
                ],
                'template' => "template/cart/mobile/{$mobileTheme}/goods.html"
            ];
        }else{ // pc端
            $cartTheme = configuration('cart_theme');
            if (!file_exists(__DIR__."/template/cart/pc/{$cartTheme}/goods.html")){
                $cartTheme = "default";
            }
            $res = [
                'vars' => [
                    'template_catalog' => 'clientarea',
                    'themes' => 'pc/'.configuration('clientarea_theme'),
                    'addons' => $addons['list']
                ],
                'template' => "template/cart/pc/{$cartTheme}/goods.html"
            ];
        }

        return $res;
    }


    /**
     * 时间 2022-09-27
     * @title 后台产品内页输出,TODO
     * @author zn
     * @version v1
     */
    public function adminArea()
    {
        $res = [
            'template'=>'template/admin/host_config.html',
        ];

        return $res;
    }

    /**
     * 时间 2022-09-27
     * @title 结算后调用,保存下单的配置项
     * @author zn
     * @version v1
     */
    public function afterSettle($params)
    {
        $IdcsmartJyvpsLogic = new IdcsmartJyvpsLogic();

        $res = $IdcsmartJyvpsLogic->afterSettle($params);

        return $res;
    }

    /**
     * 时间 2022-09-27
     * @title 获取产品所有周期价格
     * @desc 获取产品所有周期价格
     * @author zn
     * @version v1
     * @param int host_id - 产品ID
     * @return array [
     * [
    'duration' => 134,
    'price' => 1,
    'billing_cycle' => 2
    ],
     * ]
     */
    public function durationPrice($params)
    {
        $IdcsmartJyvpsLogic = new IdcsmartJyvpsLogic();

        $result = $IdcsmartJyvpsLogic->currentDurationPrice($params['host']['id']);

        return $result;
    }

    /**
     * 时间 2022-09-27
     * @title 获取商品所有配置
     * @desc 获取商品所有配置
     * @author zn
     * @version v1
     * @param int product_id - 商品ID
     * @return  array [
    'name' => $configoption['option_name'],
    'field' => "configoption[{$configoption['id']}]",
    'type' => 'dropdown',
    'option' => $subArr
    ]
     */
    public function allConfigOption($params)
    {
        $IdcsmartJyvpsLogic = new IdcsmartJyvpsLogic();

        $result = $IdcsmartJyvpsLogic->allConfigOption($params['product']['id']);

        return $result;
    }

    /**
     * 时间 2022-09-27
     * @title 获取产品当前配置
     * @desc 获取产品当前配置
     * @author zn
     * @version v1
     * @param int host_id - 产品ID
     * @return  array ["配置项ID":"子项ID"]
     */
    public function currentConfigOption($params)
    {
        $IdcsmartJyvpsLogic = new IdcsmartJyvpsLogic();

        $result = $IdcsmartJyvpsLogic->currentConfigOption($params['host']['id']);

        return $result;
    }

    public function getPriceCycle($params)
    {
        $IdcsmartJyvpsProductModel = new \server\idcsmart_jyvps\model\IdcsmartJyvpsProductModel();
        return $IdcsmartJyvpsProductModel->productMinPrice($params['product']['id']);
    }

    /**
     * 时间 2023-02-16
     * @title 资源下载
     * @desc 资源下载
     * @author hh
     * @version v1
     */
    public function downloadResource($param)
    {
        $metaData = $this->metaData();

        // 尝试解压到本地目录下
        ToolLogic::unzipToReserver();

        $result = [
            'status' => 200,
            'msg'	 => lang_plugins('success_message'),
            'data'	 => [
                'module' => 'idcsmart_jyvps',
                'url' => request()->domain() . '/plugins/server/idcsmart_jyvps/data/abc.zip' , // 下载路径
                'version' => $metaData['version'] ?? '1.0.0',
            ]
        ];
        return $result;
    }

    /**
     * 时间 2025-01-14
     * @title 验证套餐配置是否匹配
     * @desc 验证下拉框选择的套餐和卡片选择的套餐是否一致
     * @author system
     * @version v1
     * @param   int taocanid - 套餐ID（卡片选择的）
     * @param   array configoption - 配置项数组
     * @return  array
     */
    public function validatePackageMatch($params)
    {
        try {
            \think\facade\Log::info('=== validatePackageMatch 开始 ===');
            \think\facade\Log::info('收到参数: ' . json_encode($params));
            
            $taocanid = $params['taocanid'] ?? 0;
            $configoption = $params['configoption'] ?? [];
            
            \think\facade\Log::info("套餐ID: {$taocanid}");
            \think\facade\Log::info('配置项: ' . json_encode($configoption));
            
            // 如果没有套餐ID，跳过验证
            if (empty($taocanid)) {
                \think\facade\Log::info('套餐ID为空，跳过验证');
                return [
                    'status' => 400,
                    'msg' => '套餐信息不存在'
                ];
            }
            
            // 1. 从 vm_product 表获取卡片套餐名称
            $IdcsmartJyvpsVmProductModel = new IdcsmartJyvpsVmProductModel();
            $vmProduct = $IdcsmartJyvpsVmProductModel->where('id', $taocanid)->find();
            
            if (empty($vmProduct)) {
                \think\facade\Log::error('套餐信息不存在: ' . $taocanid);
                return [
                    'status' => 400,
                    'msg' => '套餐信息不存在'
                ];
            }
            
            // 提取卡片套餐名称中的套餐类型和编号
            // 如 "南京特价机房VPS（套餐一）" -> 类型="特价"，编号="套餐一"
            $cardPackageName = $vmProduct['name'];
            \think\facade\Log::info("卡片套餐名称: {$cardPackageName}");
            
            // 提取套餐类型（特价、标准、高级等）
            preg_match('/(特价|标准|高级)/', $cardPackageName, $cardTypeMatches);
            $cardPackageType = $cardTypeMatches[1] ?? '';
            
            // 提取套餐编号
            preg_match('/（(套餐[一二三四五六七八九十]+)）/', $cardPackageName, $cardMatches);
            
            if (empty($cardMatches[1])) {
                \think\facade\Log::info('卡片套餐名称中没有套餐编号，跳过验证');
                return [
                    'status' => 400,
                    'msg' => '套餐信息不存在'
                ];
            }
            
            $cardPackageNumber = $cardMatches[1]; // 如 "套餐一"
            \think\facade\Log::info("提取卡片套餐类型: {$cardPackageType}, 编号: {$cardPackageNumber}");
            
            // 2. 从配置项中查找套餐配置
            $IdcsmartJyvpsProductConfigoptionModel = new IdcsmartJyvpsProductConfigoptionModel();
            $IdcsmartJyvpsProductConfigoptionSubModel = new IdcsmartJyvpsProductConfigoptionSubModel();
            
            $packageConfigoptionSubId = null;
            
            // 遍历配置项，找到套餐配置项的选中值
            foreach ($configoption as $configoptionId => $subId) {
                // 查询配置项信息
                $configoptionInfo = $IdcsmartJyvpsProductConfigoptionModel
                    ->where('id', $configoptionId)
                    ->find();
                
                if ($configoptionInfo && $configoptionInfo['option_name'] == '套餐') {
                    $packageConfigoptionSubId = $subId;
                    break;
                }
            }
            
            // 如果没有找到套餐配置项，跳过验证
            if (empty($packageConfigoptionSubId)) {
                return [
                    'status' => 400,
                    'msg' => '套餐信息不存在'
                ];
            }
            
            // 3. 查询下拉框选择的套餐子项名称
            $configSub = $IdcsmartJyvpsProductConfigoptionSubModel
                ->where('id', $packageConfigoptionSubId)
                ->find();
            
            if (empty($configSub)) {
                return [
                    'status' => 400,
                    'msg' => '配置项信息不存在'
                ];
            }
            
            // 提取下拉框套餐名称中的套餐类型和编号
            // 如 "特价套餐一" -> 类型="特价"，编号="套餐一"
            $dropdownPackageName = $configSub['option_name'];
            \think\facade\Log::info("下拉框套餐名称: {$dropdownPackageName}");
            
            // 提取套餐类型（特价、标准、高级等）
            preg_match('/(特价|标准|高级)/', $dropdownPackageName, $dropdownTypeMatches);
            $dropdownPackageType = $dropdownTypeMatches[1] ?? '';
            
            // 提取套餐编号
            preg_match('/(套餐[一二三四五六七八九十]+)/', $dropdownPackageName, $dropdownMatches);
            
            if (empty($dropdownMatches[1])) {
                \think\facade\Log::info('下拉框套餐名称中没有套餐编号，跳过验证');
                return [
                    'status' => 400,
                    'msg' => '套餐信息不存在'
                ];
            }
            
            $dropdownPackageNumber = $dropdownMatches[1]; // 如 "套餐一"
            \think\facade\Log::info("提取下拉框套餐类型: {$dropdownPackageType}, 编号: {$dropdownPackageNumber}");
            
            // 4. 比较套餐类型和编号是否都一致
            $typeMismatch = false;
            $numberMismatch = false;
            
            // 如果卡片有类型，下拉框也必须有相同的类型
            if (!empty($cardPackageType) && $cardPackageType !== $dropdownPackageType) {
                $typeMismatch = true;
            }
            
            // 套餐编号必须一致
            if ($cardPackageNumber !== $dropdownPackageNumber) {
                $numberMismatch = true;
            }
            
            if ($typeMismatch || $numberMismatch) {
                $errorMsg = "套餐选择不匹配：";
                if ($typeMismatch && $numberMismatch) {
                    $errorMsg .= "下拉框选择了「{$dropdownPackageName}」，但卡片选择了「{$cardPackageName}」";
                } elseif ($typeMismatch) {
                    $errorMsg .= "套餐类型不一致，下拉框是「{$dropdownPackageType}」，卡片是「{$cardPackageType}」";
                } else {
                    $errorMsg .= "套餐编号不一致，下拉框是「{$dropdownPackageNumber}」，卡片是「{$cardPackageNumber}」";
                }
                $errorMsg .= "，请确保选择一致";
                
                \think\facade\Log::warning($errorMsg);
                return [
                    'status' => 400,
                    'msg' => $errorMsg
                ];
            }
            
            // 验证通过
            \think\facade\Log::info('套餐类型和编号验证通过');
            return ['status' => 200];
            
        } catch (\Exception $e) {
            return [
                'status' => 400,
                'msg' => '套餐验证失败：' . $e->getMessage()
            ];
        }
    }

}


